/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.java-time;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.java-time.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/exposed/sql/java-time/JavaLocalDateTimeColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "longToLocalDateTime", "Ljava/time/LocalDateTime;", "kotlin.jvm.PlatformType", "millis", "", "seconds", "nanos", "nonNullValueToString", "", "value", "", "notNullValueToDB", "sqlType", "valueFromDB", "Companion", "exposed-java-time"})
public final class JavaLocalDateTimeColumnType
extends ColumnType
implements IDateColumnType {
    private final boolean hasTimePart;
    @NotNull
    private static final JavaLocalDateTimeColumnType INSTANCE;
    @NotNull
    public static final Companion Companion;

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().dateTimeType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof String) {
            return (String)value;
        }
        if (object instanceof LocalDateTime) {
            instant = Instant.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()));
        } else if (object instanceof Date) {
            instant = Instant.ofEpochMilli(((Date)value).getTime());
        } else if (object instanceof Timestamp) {
            instant = Instant.ofEpochSecond(((Timestamp)value).getTime() / (long)1000, ((Timestamp)value).getNanos());
        } else {
            String string = "Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Instant instant2 = instant;
        object = DefaultKt.getCurrentDialect();
        return object instanceof SQLiteDialect || object instanceof OracleDialect ? '\'' + JavaDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER$p().format(instant2) + '\'' : '\'' + JavaDateColumnTypeKt.access$getDEFAULT_DATE_TIME_STRING_FORMATTER$p().format(instant2) + '\'';
    }

    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object2 = value;
        if (object2 instanceof LocalDateTime) {
            object = value;
        } else if (object2 instanceof Date) {
            LocalDateTime localDateTime = this.longToLocalDateTime(((Date)value).getTime());
            object = localDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"longToLocalDateTime(value.time)");
        } else if (object2 instanceof Timestamp) {
            LocalDateTime localDateTime = this.longToLocalDateTime(((Timestamp)value).getTime() / (long)1000, ((Timestamp)value).getNanos());
            object = localDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"longToLocalDateTime(valu\u202600, value.nanos.toLong())");
        } else if (object2 instanceof Integer) {
            LocalDateTime localDateTime = this.longToLocalDateTime(((Number)value).intValue());
            object = localDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"longToLocalDateTime(value.toLong())");
        } else if (object2 instanceof Long) {
            LocalDateTime localDateTime = this.longToLocalDateTime(((Number)value).longValue());
            object = localDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"longToLocalDateTime(value)");
        } else if (object2 instanceof String) {
            LocalDateTime localDateTime = LocalDateTime.parse((CharSequence)value, JavaDateColumnTypeKt.access$formatterForDateString((String)value));
            object = localDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"LocalDateTime.parse(valu\u2026tterForDateString(value))");
        } else {
            object = this.valueFromDB(value.toString());
        }
        return object;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof LocalDateTime && DefaultKt.getCurrentDialect() instanceof SQLiteDialect) {
            String string = JavaDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER$p().format(((LocalDateTime)value).atZone(ZoneId.systemDefault()));
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SQLITE_AND_ORACLE_DATE_T\u2026(ZoneId.systemDefault()))");
        } else {
            object = value instanceof LocalDateTime ? new Timestamp(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()) : value;
        }
        return object;
    }

    private final LocalDateTime longToLocalDateTime(long millis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
    }

    private final LocalDateTime longToLocalDateTime(long seconds, long nanos) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(seconds, nanos), ZoneId.systemDefault());
    }

    public JavaLocalDateTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    static {
        Companion = new Companion(null);
        INSTANCE = new JavaLocalDateTimeColumnType();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/java-time/JavaLocalDateTimeColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/java-time/JavaLocalDateTimeColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/java-time/JavaLocalDateTimeColumnType;", "exposed-java-time"})
    public static final class Companion {
        @NotNull
        public final JavaLocalDateTimeColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

