/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.gradle.process.ExecResult;
import org.jetbrains.compose.desktop.application.internal.ExternalToolRunner;
import org.jetbrains.compose.internal.utils.MacUtils;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u001a%\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\t\u001a%\u0010\n\u001a\u00020\u000b*\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u000e\u001a:\u0010\u000f\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u0016"}, d2={"isExecutable", "", "Ljava/io/File;", "(Ljava/io/File;)Z", "optionalArg", "", "", "arg", "value", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "codesign", "Lorg/gradle/process/ExecResult;", "Lorg/jetbrains/compose/desktop/application/internal/ExternalToolRunner;", "args", "(Lorg/jetbrains/compose/desktop/application/internal/ExternalToolRunner;[Ljava/lang/String;)Lorg/gradle/process/ExecResult;", "sign", "file", "signKey", "entitlements", "prefix", "keychain", "unsign", "compose"})
public final class MacSignerKt {
    private static final ExecResult codesign(ExternalToolRunner $this$codesign, String ... args2) {
        return ExternalToolRunner.invoke$default($this$codesign, MacUtils.INSTANCE.getCodesign(), ArraysKt.toList((Object[])args2), null, null, false, null, null, null, 252, null);
    }

    private static final ExecResult unsign(ExternalToolRunner $this$unsign, File file2) {
        String[] stringArray = new String[3];
        stringArray[0] = "-vvvv";
        stringArray[1] = "--remove-signature";
        Intrinsics.checkNotNullExpressionValue((Object)file2.getAbsolutePath(), (String)"file.absolutePath");
        return MacSignerKt.codesign($this$unsign, stringArray);
    }

    private static final ExecResult sign(ExternalToolRunner $this$sign, File file2, String signKey2, File entitlements, String prefix, File keychain) {
        SpreadBuilder spreadBuilder = new SpreadBuilder(11);
        spreadBuilder.add((Object)"-vvvv");
        spreadBuilder.add((Object)"--timestamp");
        spreadBuilder.add((Object)"--options");
        spreadBuilder.add((Object)"runtime");
        spreadBuilder.add((Object)"--force");
        spreadBuilder.addSpread((Object)MacSignerKt.optionalArg("--prefix", prefix));
        spreadBuilder.add((Object)"--sign");
        spreadBuilder.add((Object)signKey2);
        File file3 = keychain;
        spreadBuilder.addSpread((Object)MacSignerKt.optionalArg("--keychain", file3 != null ? file3.getAbsolutePath() : null));
        File file4 = entitlements;
        spreadBuilder.addSpread((Object)MacSignerKt.optionalArg("--entitlements", file4 != null ? file4.getAbsolutePath() : null));
        String string = file2.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
        spreadBuilder.add((Object)string);
        return MacSignerKt.codesign($this$sign, (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    private static final String[] optionalArg(String arg, String value) {
        String[] stringArray;
        if (value != null) {
            String[] stringArray2 = new String[]{arg, value};
            stringArray = stringArray2;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private static final boolean isExecutable(File $this$isExecutable) {
        Path path = $this$isExecutable.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath()");
        return Files.isExecutable(path);
    }

    public static final /* synthetic */ ExecResult access$unsign(ExternalToolRunner $receiver, File file2) {
        return MacSignerKt.unsign($receiver, file2);
    }

    public static final /* synthetic */ ExecResult access$codesign(ExternalToolRunner $receiver, String ... args2) {
        return MacSignerKt.codesign($receiver, args2);
    }

    public static final /* synthetic */ ExecResult access$sign(ExternalToolRunner $receiver, File file2, String signKey2, File entitlements, String prefix, File keychain) {
        return MacSignerKt.sign($receiver, file2, signKey2, entitlements, prefix, keychain);
    }

    public static final /* synthetic */ boolean access$isExecutable(File $receiver) {
        return MacSignerKt.isExecutable($receiver);
    }
}

