/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.internal.validation.VersionChecker;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J#\u0010\n\u001a\u00020\b*\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/compose/desktop/application/internal/validation/WindowsVersionChecker;", "Lorg/jetbrains/compose/desktop/application/internal/validation/VersionChecker;", "()V", "correctFormat", "", "getCorrectFormat", "()Ljava/lang/String;", "isValid", "", "version", "isIntInRange", "", "min", "max", "(Ljava/lang/Integer;II)Z", "compose"})
@SourceDebugExtension(value={"SMAP\nvalidatePackageVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 validatePackageVersions.kt\norg/jetbrains/compose/desktop/application/internal/validation/WindowsVersionChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1549#2:187\n1620#2,3:188\n*S KotlinDebug\n*F\n+ 1 validatePackageVersions.kt\norg/jetbrains/compose/desktop/application/internal/validation/WindowsVersionChecker\n*L\n157#1:187\n157#1:188,3\n*E\n"})
final class WindowsVersionChecker
implements VersionChecker {
    @NotNull
    public static final WindowsVersionChecker INSTANCE = new WindowsVersionChecker();
    @NotNull
    private static final String correctFormat = "'MAJOR.MINOR.BUILD', where:\n    * MAJOR is a non-negative integer with a maximum value of 255;\n    * MINOR is a non-negative integer with a maximum value of 255;\n    * BUILD is a non-negative integer with a maximum value of 65535;";

    private WindowsVersionChecker() {
    }

    @Override
    @NotNull
    public String getCorrectFormat() {
        return correctFormat;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isValid(@NotNull String version) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        String[] stringArray = new String[]{"."};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)version, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.toIntOrNull((String)it));
        }
        List parts = (List)destination$iv$iv;
        if (parts.size() != 3) {
            return false;
        }
        return this.isIntInRange((Integer)parts.get(0), 0, 255) && this.isIntInRange((Integer)parts.get(1), 0, 255) && this.isIntInRange((Integer)parts.get(2), 0, 65535);
    }

    private final boolean isIntInRange(Integer $this$isIntInRange, int min, int max) {
        return $this$isIntInRange != null && $this$isIntInRange >= min && $this$isIntInRange <= max;
    }
}

