/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.application.internal.MacSigner;
import org.jetbrains.compose.desktop.application.internal.files.MacJarSignFileCopyingProcessorKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/compose/desktop/application/internal/MacSigningHelper;", "", "macSigner", "Lorg/jetbrains/compose/desktop/application/internal/MacSigner;", "runtimeProvisioningProfile", "Ljava/io/File;", "entitlementsFile", "runtimeEntitlementsFile", "destinationDir", "packageName", "", "(Lorg/jetbrains/compose/desktop/application/internal/MacSigner;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/lang/String;)V", "appDir", "runtimeDir", "modifyRuntimeIfNeeded", "", "compose"})
@SourceDebugExtension(value={"SMAP\nMacSigningHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacSigningHelper.kt\norg/jetbrains/compose/desktop/application/internal/MacSigningHelper\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,41:1\n1313#2,2:42\n*S KotlinDebug\n*F\n+ 1 MacSigningHelper.kt\norg/jetbrains/compose/desktop/application/internal/MacSigningHelper\n*L\n30#1:42,2\n*E\n"})
public final class MacSigningHelper {
    @NotNull
    private final MacSigner macSigner;
    @Nullable
    private final File runtimeProvisioningProfile;
    @Nullable
    private final File entitlementsFile;
    @Nullable
    private final File runtimeEntitlementsFile;
    @NotNull
    private final File appDir;
    @NotNull
    private final File runtimeDir;

    public MacSigningHelper(@NotNull MacSigner macSigner2, @Nullable File runtimeProvisioningProfile, @Nullable File entitlementsFile, @Nullable File runtimeEntitlementsFile, @NotNull File destinationDir, @NotNull String packageName2) {
        Intrinsics.checkNotNullParameter((Object)macSigner2, (String)"macSigner");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        this.macSigner = macSigner2;
        this.runtimeProvisioningProfile = runtimeProvisioningProfile;
        this.entitlementsFile = entitlementsFile;
        this.runtimeEntitlementsFile = runtimeEntitlementsFile;
        this.appDir = FilesKt.resolve((File)destinationDir, (String)(packageName2 + ".app"));
        this.runtimeDir = FilesKt.resolve((File)this.appDir, (String)"Contents/runtime");
    }

    public final void modifyRuntimeIfNeeded() {
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)this.runtimeDir, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file2 = (File)element$iv;
            boolean bl = false;
            Path path = file2.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            Path path2 = path;
            LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
            if (!Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            if (!Files.isExecutable(path)) {
                String string = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                if (!MacJarSignFileCopyingProcessorKt.isDylibPath(string)) continue;
            }
            MacSigner.sign$default(this.macSigner, file2, this.runtimeEntitlementsFile, false, 4, null);
        }
        this.macSigner.sign(this.runtimeDir, this.runtimeEntitlementsFile, true);
        this.macSigner.sign(this.appDir, this.entitlementsFile, true);
    }
}

