/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.when.impl;

import hudson.Extension;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.codehaus.groovy.ast.expr.Expression;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTWhenContent;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.ASTParserUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditional;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditionalDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class ChangeLogConditional
extends DeclarativeStageConditional<ChangeLogConditional> {
    private Pattern pattern;
    private Pattern multiLinePattern;

    @DataBoundConstructor
    public ChangeLogConditional(String pattern) {
        this.pattern = Pattern.compile(pattern);
        this.multiLinePattern = Pattern.compile(ChangeLogConditional.expandForMultiLine(pattern), 40);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Pattern getMultiLinePattern() {
        return this.multiLinePattern;
    }

    @Restricted(value={NoExternalUse.class})
    public static String expandForMultiLine(String pattern) {
        return "(?m)(?s)^[^\\r\\n]*?" + pattern + "[^\\r\\n]*?$";
    }

    @Extension
    @Symbol(value={"changelog"})
    public static class DescriptorImpl
    extends DeclarativeStageConditionalDescriptor<ChangeLogConditional> {
        public Expression transformToRuntimeAST(@CheckForNull ModelASTWhenContent original) {
            return ASTParserUtils.transformWhenContentToRuntimeAST(original);
        }
    }
}

