/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.when.impl;

import hudson.Extension;
import java.io.File;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.codehaus.groovy.ast.expr.Expression;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTWhenContent;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.ASTParserUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditional;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditionalDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class BranchConditional
extends DeclarativeStageConditional<BranchConditional> {
    private final String compare;

    @DataBoundConstructor
    public BranchConditional(String compare) {
        this.compare = compare;
    }

    public String getCompare() {
        return this.compare;
    }

    public boolean branchMatches(String toCompare, String actualBranch) {
        if (StringUtils.isEmpty((String)actualBranch) && StringUtils.isEmpty((String)toCompare)) {
            return true;
        }
        if (StringUtils.isEmpty((String)actualBranch) || StringUtils.isEmpty((String)toCompare)) {
            return false;
        }
        String safeCompare = toCompare.replace('/', File.separatorChar);
        String safeName = actualBranch.replace('/', File.separatorChar);
        return SelectorUtils.matchPath((String)safeCompare, (String)safeName, (boolean)false);
    }

    @Extension
    @Symbol(value={"branch"})
    public static class DescriptorImpl
    extends DeclarativeStageConditionalDescriptor<BranchConditional> {
        public Expression transformToRuntimeAST(@CheckForNull ModelASTWhenContent original) {
            return ASTParserUtils.transformWhenContentToRuntimeAST(original);
        }
    }
}

