/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.endpoints;

import com.google.common.collect.ImmutableList;
import hudson.Extension;
import hudson.model.RootAction;
import hudson.security.csrf.CrumbExclusion;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPipelineDef;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStep;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.Converter;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.JSONParser;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.JsonTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SimpleJsonTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.JsonLoader;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ErrorCollector;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class ModelConverterAction
implements RootAction {
    public static final String PIPELINE_CONVERTER_URL = "pipeline-model-converter";

    public String getUrlName() {
        return PIPELINE_CONVERTER_URL;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    @RequirePOST
    public HttpResponse doToJenkinsfile(StaplerRequest req) {
        JSONObject result;
        block6: {
            Jenkins.getInstance().checkPermission(Jenkins.READ);
            result = new JSONObject();
            String jsonAsString = req.getParameter("json");
            if (!StringUtils.isEmpty((String)jsonAsString)) {
                try {
                    JsonNode json = JsonLoader.fromString((String)jsonAsString);
                    JSONParser parser = new JSONParser((JsonTree)new SimpleJsonTree(json));
                    ModelASTPipelineDef pipelineDef = parser.parse();
                    if (this.collectErrors(result, parser.getErrorCollector())) break block6;
                    try {
                        Converter.scriptToPipelineDef(pipelineDef.toPrettyGroovy());
                        result.accumulate("result", (Object)"success");
                        result.accumulate("jenkinsfile", (Object)pipelineDef.toPrettyGroovy());
                    }
                    catch (Exception e) {
                        JSONObject jfErrors = new JSONObject();
                        this.reportFailure(jfErrors, e);
                        JSONArray errors = new JSONArray();
                        errors.add((Object)new JSONObject().accumulate("jenkinsfileErrors", (Object)jfErrors));
                        this.reportFailure(result, errors);
                    }
                }
                catch (Exception je) {
                    this.reportFailure(result, je);
                }
            } else {
                this.reportFailure(result, "No content found for 'json' parameter");
            }
        }
        return HttpResponses.okJSON((JSONObject)result);
    }

    @RequirePOST
    public HttpResponse doToJson(StaplerRequest req) {
        JSONObject result;
        block5: {
            Jenkins.getInstance().checkPermission(Jenkins.READ);
            result = new JSONObject();
            String groovyAsString = req.getParameter("jenkinsfile");
            if (!StringUtils.isEmpty((String)groovyAsString)) {
                try {
                    ModelASTPipelineDef pipelineDef = Converter.scriptToPipelineDef(groovyAsString);
                    if (pipelineDef != null) {
                        result.accumulate("result", (Object)"success");
                        result.accumulate("json", (Object)pipelineDef.toJSON());
                        break block5;
                    }
                    this.reportFailure(result, "Jenkinsfile content '" + groovyAsString + "' did not contain the 'pipeline' step");
                }
                catch (Exception e) {
                    this.reportFailure(result, e);
                }
            } else {
                this.reportFailure(result, "No content found for 'jenkinsfile' parameter");
            }
        }
        return HttpResponses.okJSON((JSONObject)result);
    }

    @RequirePOST
    public HttpResponse doStepsToJson(StaplerRequest req) {
        Jenkins.getInstance().checkPermission(Jenkins.READ);
        JSONObject result = new JSONObject();
        String groovyAsString = req.getParameter("jenkinsfile");
        if (!StringUtils.isEmpty((String)groovyAsString)) {
            try {
                List<ModelASTStep> steps = Converter.scriptToPlainSteps(groovyAsString);
                JSONArray array = new JSONArray();
                for (ModelASTStep step : steps) {
                    array.add((Object)step.toJSON());
                }
                result.accumulate("result", (Object)"success");
                result.accumulate("json", (Object)array);
            }
            catch (Exception e) {
                this.reportFailure(result, e);
            }
        } else {
            this.reportFailure(result, "No content found for 'jenkinsfile' parameter");
        }
        return HttpResponses.okJSON((JSONObject)result);
    }

    @RequirePOST
    public HttpResponse doStepsToJenkinsfile(StaplerRequest req) {
        Jenkins.getInstance().checkPermission(Jenkins.READ);
        JSONObject result = new JSONObject();
        String jsonAsString = req.getParameter("json");
        if (!StringUtils.isEmpty((String)jsonAsString)) {
            try {
                JsonNode json = JsonLoader.fromString((String)jsonAsString);
                ArrayList<JsonNode> jsonSteps = new ArrayList<JsonNode>();
                if (json.isArray()) {
                    jsonSteps.addAll((Collection<JsonNode>)ImmutableList.copyOf((Iterator)json.elements()));
                } else {
                    jsonSteps.add(json);
                }
                JSONParser parser = new JSONParser(null);
                ArrayList<ModelASTStep> astSteps = new ArrayList<ModelASTStep>(jsonSteps.size());
                for (JsonNode jsonStep : jsonSteps) {
                    ModelASTStep astStep;
                    if (!jsonStep.isObject() || (astStep = parser.parseStep((JsonTree)new SimpleJsonTree(jsonStep))) == null) continue;
                    astStep.validate(parser.getValidator());
                    astSteps.add(astStep);
                }
                boolean collectedSomeErrors = this.collectErrors(result, parser.getErrorCollector());
                if (!collectedSomeErrors && astSteps.isEmpty()) {
                    this.reportFailure(result, "No result.");
                } else if (!collectedSomeErrors) {
                    result.accumulate("result", (Object)"success");
                    StringBuilder jenkinsFile = new StringBuilder();
                    for (ModelASTStep step : astSteps) {
                        if (jenkinsFile.length() > 0) {
                            jenkinsFile.append('\n');
                        }
                        jenkinsFile.append(step.toGroovy());
                    }
                    result.accumulate("jenkinsfile", (Object)jenkinsFile.toString());
                }
            }
            catch (Exception je) {
                this.reportFailure(result, je);
            }
        } else {
            this.reportFailure(result, "No content found for 'json' parameter");
        }
        return HttpResponses.okJSON((JSONObject)result);
    }

    @RequirePOST
    public HttpResponse doValidateJenkinsfile(StaplerRequest req) {
        JSONObject result;
        block5: {
            Jenkins.getInstance().checkPermission(Jenkins.READ);
            result = new JSONObject();
            String groovyAsString = req.getParameter("jenkinsfile");
            if (!StringUtils.isEmpty((String)groovyAsString)) {
                try {
                    ModelASTPipelineDef pipelineDef = Converter.scriptToPipelineDef(groovyAsString);
                    if (pipelineDef != null) {
                        result.accumulate("result", (Object)"success");
                        break block5;
                    }
                    this.reportFailure(result, "Jenkinsfile content '" + groovyAsString + "' did not contain the 'pipeline' step");
                }
                catch (Exception e) {
                    this.reportFailure(result, e);
                }
            } else {
                this.reportFailure(result, "No content found for 'jenkinsfile' parameter");
            }
        }
        return HttpResponses.okJSON((JSONObject)result);
    }

    @RequirePOST
    public HttpResponse doValidateJson(StaplerRequest req) {
        JSONObject result;
        block6: {
            Jenkins.getInstance().checkPermission(Jenkins.READ);
            result = new JSONObject();
            String jsonAsString = req.getParameter("json");
            if (!StringUtils.isEmpty((String)jsonAsString)) {
                try {
                    JsonNode json = JsonLoader.fromString((String)jsonAsString);
                    JSONParser parser = new JSONParser((JsonTree)new SimpleJsonTree(json));
                    ModelASTPipelineDef pipelineDef = parser.parse();
                    if (pipelineDef == null || this.collectErrors(result, parser.getErrorCollector()) || !result.isEmpty()) break block6;
                    try {
                        Converter.scriptToPipelineDef(pipelineDef.toPrettyGroovy());
                        result.accumulate("result", (Object)"success");
                    }
                    catch (Exception e) {
                        JSONObject jfErrors = new JSONObject();
                        this.reportFailure(jfErrors, e);
                        JSONArray errors = new JSONArray();
                        errors.add((Object)new JSONObject().accumulate("jenkinsfileErrors", (Object)jfErrors));
                        this.reportFailure(result, errors);
                    }
                }
                catch (Exception je) {
                    this.reportFailure(result, je);
                }
            } else {
                this.reportFailure(result, "No content found for 'json' parameter");
            }
        }
        return HttpResponses.okJSON((JSONObject)result);
    }

    @RequirePOST
    public HttpResponse doValidate(StaplerRequest req) {
        ArrayList<String> output;
        block5: {
            Jenkins.getInstance().checkPermission(Jenkins.READ);
            output = new ArrayList<String>();
            String groovyAsString = req.getParameter("jenkinsfile");
            if (groovyAsString != null) {
                try {
                    if (Converter.scriptToPipelineDef(groovyAsString) != null) {
                        output.add("Jenkinsfile successfully validated.");
                        break block5;
                    }
                    output.add("Jenkinsfile content '" + groovyAsString + "' did not contain the 'pipeline' step");
                }
                catch (Exception e) {
                    output.add("Errors encountered validating Jenkinsfile:");
                    output.addAll(ModelConverterAction.errorToStrings(e));
                }
            } else {
                output.add("No Jenkinsfile specified");
            }
        }
        return HttpResponses.plainText((String)StringUtils.join(output, (String)"\n"));
    }

    public static List<String> errorToStrings(Exception e) {
        ArrayList<String> output = new ArrayList<String>();
        if (e instanceof MultipleCompilationErrorsException) {
            MultipleCompilationErrorsException ce = (MultipleCompilationErrorsException)e;
            for (Object o : ce.getErrorCollector().getErrors()) {
                if (!(o instanceof SyntaxErrorMessage)) continue;
                SyntaxErrorMessage s = (SyntaxErrorMessage)o;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                s.write(pw);
                pw.close();
                output.add(sw.toString());
            }
        } else {
            output.add(e.getMessage());
        }
        return output;
    }

    private boolean collectErrors(JSONObject result, ErrorCollector errorCollector) {
        if (errorCollector.getErrorCount() > 0) {
            JSONArray errors = errorCollector.asJson();
            this.reportFailure(result, errors);
            return true;
        }
        return false;
    }

    private void reportFailure(JSONObject result, Exception e) {
        JSONArray errors = new JSONArray();
        JSONObject j = new JSONObject();
        if (e instanceof MultipleCompilationErrorsException) {
            MultipleCompilationErrorsException ce = (MultipleCompilationErrorsException)e;
            for (Object o : ce.getErrorCollector().getErrors()) {
                if (!(o instanceof SyntaxErrorMessage)) continue;
                j.accumulate("error", (Object)((SyntaxErrorMessage)o).getCause().getMessage());
            }
        } else {
            j.accumulate("error", (Object)e.getMessage());
        }
        errors.add((Object)j);
        this.reportFailure(result, errors);
    }

    private void reportFailure(JSONObject result, String message) {
        JSONArray errors = new JSONArray();
        JSONObject o = new JSONObject();
        o.accumulate("error", (Object)message);
        errors.add((Object)o);
        this.reportFailure(result, errors);
    }

    private void reportFailure(JSONObject result, JSONArray errors) {
        result.accumulate("result", (Object)"failure");
        result.accumulate("errors", (Object)errors);
    }

    @Extension
    public static class ModelConverterActionCrumbExclusion
    extends CrumbExclusion {
        public boolean process(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
            String pathInfo = req.getPathInfo();
            if (pathInfo != null && pathInfo.startsWith("/pipeline-model-converter/")) {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                return true;
            }
            return false;
        }
    }
}

