/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.actions;

import hudson.model.InvisibleAction;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.triggers.Trigger;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class DeclarativeJobPropertyTrackerAction
extends InvisibleAction {
    private final Set<String> jobProperties = new HashSet<String>();
    private final Set<String> triggers = new HashSet<String>();
    private final Set<String> parameters = new HashSet<String>();

    public DeclarativeJobPropertyTrackerAction(@CheckForNull List<JobProperty> rawJobProperties, @CheckForNull List<Trigger> rawTriggers, @CheckForNull List<ParameterDefinition> rawParameters) {
        if (rawJobProperties != null) {
            for (JobProperty p : rawJobProperties) {
                this.jobProperties.add(p.getDescriptor().getId());
            }
        }
        if (rawTriggers != null) {
            for (Trigger t : rawTriggers) {
                this.triggers.add(t.getDescriptor().getId());
            }
        }
        if (rawParameters != null) {
            for (ParameterDefinition d : rawParameters) {
                this.parameters.add(d.getName());
            }
        }
    }

    public DeclarativeJobPropertyTrackerAction(@Nonnull DeclarativeJobPropertyTrackerAction copyFrom) {
        this.jobProperties.addAll(copyFrom.getJobProperties());
        this.triggers.addAll(copyFrom.getTriggers());
        this.parameters.addAll(copyFrom.getParameters());
    }

    public Set<String> getJobProperties() {
        return Collections.unmodifiableSet(this.jobProperties);
    }

    public Set<String> getTriggers() {
        return Collections.unmodifiableSet(this.triggers);
    }

    public Set<String> getParameters() {
        return Collections.unmodifiableSet(this.parameters);
    }

    public String toString() {
        return "DeclarativeJobPropertyTrackerAction[jobProperties:" + this.jobProperties + ",triggers:" + this.triggers + ",parameters:" + this.parameters + "]";
    }
}

