/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTMarkerInterface;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStep;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public class ModelASTTreeStep
extends ModelASTStep {
    private List<ModelASTStep> children = new ArrayList<ModelASTStep>();

    public ModelASTTreeStep(Object sourceLocation) {
        super(sourceLocation);
    }

    @Override
    @NonNull
    public JSONObject toJSON() {
        return super.toJSON().accumulate("children", (Object)ModelASTTreeStep.toJSONArray(this.children));
    }

    @Override
    public void validate(@NonNull ModelValidator validator) {
        super.validate(validator);
        ModelASTTreeStep.validate(validator, this.children, new ModelASTMarkerInterface[0]);
    }

    @Override
    @NonNull
    public String toGroovy() {
        return ModelASTTreeStep.toGroovyBlock(super.toGroovy(), this.children);
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        ModelASTTreeStep.removeSourceLocationsFrom(this.children);
    }

    public List<ModelASTStep> getChildren() {
        return this.children;
    }

    public void setChildren(List<ModelASTStep> children) {
        this.children = children;
    }

    @Override
    public String toString() {
        return "ModelASTTreeStep{name='" + this.getName() + '\'' + ", args=" + this.getArgs() + ", children=" + this.children + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTTreeStep that = (ModelASTTreeStep)o;
        return this.getChildren() != null ? this.getChildren().equals(that.getChildren()) : that.getChildren() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getChildren() != null ? this.getChildren().hashCode() : 0);
        return result;
    }
}

