/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTWhenContent;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public class ModelASTWhen
extends ModelASTElement {
    private List<ModelASTWhenContent> conditions = new ArrayList<ModelASTWhenContent>();
    private Boolean beforeAgent;
    private Boolean beforeInput;

    public ModelASTWhen(Object sourceLocation) {
        super(sourceLocation);
    }

    public List<ModelASTWhenContent> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<ModelASTWhenContent> conditions) {
        this.conditions = conditions;
    }

    public Boolean getBeforeAgent() {
        return this.beforeAgent;
    }

    public void setBeforeAgent(Boolean beforeAgent) {
        this.beforeAgent = beforeAgent;
    }

    public Boolean getBeforeInput() {
        return this.beforeInput;
    }

    public void setBeforeInput(Boolean beforeInput) {
        this.beforeInput = beforeInput;
    }

    @Override
    public Object toJSON() {
        JSONObject o = new JSONObject();
        JSONArray a = new JSONArray();
        for (ModelASTWhenContent c : this.conditions) {
            a.add(c.toJSON());
        }
        o.accumulate("conditions", (Object)a);
        if (this.beforeAgent != null) {
            o.accumulate("beforeAgent", (Object)this.beforeAgent);
        }
        if (this.beforeInput != null) {
            o.accumulate("beforeInput", (Object)this.beforeInput);
        }
        return o;
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder("when {\n");
        if (this.beforeAgent != null && this.beforeAgent.booleanValue()) {
            result.append("beforeAgent true\n");
        }
        if (this.beforeInput != null && this.beforeInput.booleanValue()) {
            result.append("beforeInput true\n");
        }
        for (ModelASTWhenContent c : this.conditions) {
            result.append(c.toGroovy()).append("\n");
        }
        result.append("}\n");
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        for (ModelASTWhenContent c : this.conditions) {
            c.removeSourceLocation();
        }
    }

    @Override
    public String toString() {
        return "ModelASTWhen{conditions=" + this.conditions + ", beforeAgent=" + this.beforeAgent + ", beforeInput=" + this.beforeInput + "}";
    }

    @Override
    public void validate(@Nonnull ModelValidator validator) {
        validator.validateElement(this);
        for (ModelASTWhenContent c : this.conditions) {
            c.validate(validator);
        }
    }
}

