/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTKey;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public final class ModelASTTools
extends ModelASTElement {
    private Map<ModelASTKey, ModelASTValue> tools = new LinkedHashMap<ModelASTKey, ModelASTValue>();

    public ModelASTTools(Object sourceLocation) {
        super(sourceLocation);
    }

    public JSONArray toJSON() {
        JSONArray a = new JSONArray();
        for (Map.Entry<ModelASTKey, ModelASTValue> entry : this.tools.entrySet()) {
            JSONObject o = new JSONObject();
            o.accumulate("key", entry.getKey().toJSON());
            o.accumulate("value", (Object)entry.getValue().toJSON());
            a.add((Object)o);
        }
        return a;
    }

    @Override
    public void validate(@Nonnull ModelValidator validator) {
        validator.validateElement(this);
        for (Map.Entry<ModelASTKey, ModelASTValue> entry : this.tools.entrySet()) {
            entry.getKey().validate(validator);
            entry.getValue().validate(validator);
        }
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder("tools {\n");
        for (Map.Entry<ModelASTKey, ModelASTValue> entry : this.tools.entrySet()) {
            result.append(entry.getKey().toGroovy()).append(' ').append(entry.getValue().toGroovy()).append('\n');
        }
        result.append("}\n");
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        for (Map.Entry<ModelASTKey, ModelASTValue> entry : this.tools.entrySet()) {
            entry.getKey().removeSourceLocation();
            entry.getValue().removeSourceLocation();
        }
    }

    public Map<ModelASTKey, ModelASTValue> getTools() {
        return this.tools;
    }

    public void setTools(Map<ModelASTKey, ModelASTValue> tools) {
        this.tools = tools;
    }

    @Override
    public String toString() {
        return "ModelASTTools{tools=" + this.tools + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTTools that = (ModelASTTools)o;
        return this.getTools() != null ? this.getTools().equals(that.getTools()) : that.getTools() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getTools() != null ? this.getTools().hashCode() : 0);
        return result;
    }
}

