/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public final class ModelASTPositionalArgumentList
extends ModelASTArgumentList {
    private List<ModelASTValue> arguments = new ArrayList<ModelASTValue>();

    public ModelASTPositionalArgumentList(Object sourceLocation) {
        super(sourceLocation);
    }

    public JSONArray toJSON() {
        JSONArray a = new JSONArray();
        for (ModelASTValue argument : this.arguments) {
            a.add((Object)argument.toJSON());
        }
        return a;
    }

    @Override
    public void validate(@Nonnull ModelValidator validator) {
        for (ModelASTValue argument : this.arguments) {
            argument.validate(validator);
        }
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (ModelASTValue argument : this.arguments) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(argument.toGroovy());
        }
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        for (ModelASTValue argument : this.arguments) {
            argument.removeSourceLocation();
        }
    }

    public List<ModelASTValue> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<ModelASTValue> arguments) {
        this.arguments = arguments;
    }

    @Override
    public Map<String, ?> argListToMap() {
        ArrayList<Object> argList = new ArrayList<Object>();
        for (ModelASTValue v : this.arguments) {
            argList.add(v.getValue());
        }
        return Collections.singletonMap("<anonymous>", argList);
    }

    @Override
    public String toString() {
        return "ModelASTPositionalArgumentList{arguments=" + this.arguments + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTPositionalArgumentList that = (ModelASTPositionalArgumentList)o;
        return this.getArguments() != null ? this.getArguments().equals(that.getArguments()) : that.getArguments() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getArguments() != null ? this.getArguments().hashCode() : 0);
        return result;
    }
}

