/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension
public class DescriptorLookupCache {
    private transient Map<String, StepDescriptor> stepMap;
    private transient Map<String, DescribableModel<? extends Step>> modelMap;
    private transient Map<String, Descriptor<? extends Describable>> describableMap;
    private transient Map<String, DescribableModel<? extends Describable>> describableModelMap;

    public static DescriptorLookupCache getPublicCache() {
        return (DescriptorLookupCache)ExtensionList.lookup(DescriptorLookupCache.class).get(0);
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void invalidateGlobalCache() {
        DescriptorLookupCache.getPublicCache().invalidateAll();
    }

    public DescriptorLookupCache() {
        this.invalidateAll();
    }

    public synchronized void invalidateAll() {
        this.stepMap = new LinkedHashMap<String, StepDescriptor>();
        this.modelMap = new LinkedHashMap<String, DescribableModel<? extends Step>>();
        this.describableMap = new LinkedHashMap<String, Descriptor<? extends Describable>>();
        this.describableModelMap = new LinkedHashMap<String, DescribableModel<? extends Describable>>();
    }

    public synchronized DescribableModel<? extends Step> modelForStep(String n) {
        if (!this.modelMap.containsKey(n)) {
            StepDescriptor descriptor = this.lookupStepDescriptor(n);
            Class c = descriptor == null ? null : descriptor.clazz;
            this.modelMap.put(n, (DescribableModel<? extends Step>)(c != null ? new DescribableModel(c) : null));
        }
        return this.modelMap.get(n);
    }

    public synchronized DescribableModel<? extends Describable> modelForDescribable(String n) {
        return this.modelForDescribable(n, null);
    }

    public synchronized DescribableModel<? extends Describable> modelForDescribable(String n, @CheckForNull Class<? extends Describable> describable) {
        if (describable == null) {
            if (!this.describableModelMap.containsKey(n)) {
                Descriptor<? extends Describable> function = this.lookupFunction(n);
                Class c = function == null ? null : function.clazz;
                this.describableModelMap.put(n, (DescribableModel<? extends Describable>)(c != null ? new DescribableModel(c) : null));
            }
            return this.describableModelMap.get(n);
        }
        Descriptor<? extends Describable> function = this.lookupFunction(n, describable);
        Class c = function == null ? null : function.clazz;
        return c != null ? new DescribableModel(c) : null;
    }

    public synchronized StepDescriptor lookupStepDescriptor(String n) {
        if (this.stepMap.isEmpty()) {
            for (StepDescriptor d : StepDescriptor.all()) {
                this.stepMap.put(d.getFunctionName(), d);
            }
        }
        return this.stepMap.get(n);
    }

    public synchronized Descriptor<? extends Describable> lookupFunction(String n) {
        return this.lookupFunction(n, null);
    }

    public synchronized Descriptor<? extends Describable> lookupFunction(String n, @CheckForNull Class<? extends Describable> describable) {
        if (n == null) {
            return null;
        }
        if (describable == null) {
            if (!this.describableMap.containsKey(n)) {
                Descriptor d = SymbolLookup.get().findDescriptor(Describable.class, n);
                this.describableMap.put(n, (Descriptor<? extends Describable>)d);
            }
            return this.describableMap.get(n);
        }
        return SymbolLookup.get().findDescriptor(describable, n);
    }

    public synchronized Descriptor<? extends Describable> lookupStepFirstThenFunction(String name) {
        return this.lookupStepFirstThenFunction(name, null);
    }

    public synchronized Descriptor<? extends Describable> lookupFunctionFirstThenStep(String name) {
        return this.lookupFunctionFirstThenStep(name, null);
    }

    public synchronized DescribableModel<? extends Describable> modelForStepFirstThenFunction(String name) {
        return this.modelForStepFirstThenFunction(name, null);
    }

    public synchronized DescribableModel<? extends Describable> modelForFunctionFirstThenStep(String name) {
        return this.modelForFunctionFirstThenStep(name, null);
    }

    public synchronized Descriptor<? extends Describable> lookupStepFirstThenFunction(String name, Class<? extends Describable> describable) {
        return this.lookupStepDescriptor(name) != null ? this.lookupStepDescriptor(name) : this.lookupFunction(name, describable);
    }

    public synchronized Descriptor<? extends Describable> lookupFunctionFirstThenStep(String name, Class<? extends Describable> describable) {
        return this.lookupFunction(name, describable) != null ? this.lookupFunction(name, describable) : this.lookupStepDescriptor(name);
    }

    public synchronized DescribableModel<? extends Describable> modelForStepFirstThenFunction(String name, Class<? extends Describable> describable) {
        Descriptor<? extends Describable> desc = this.lookupStepDescriptor(name);
        DescribableModel<? extends Step> model = null;
        if (desc != null) {
            model = this.modelForStep(name);
        } else {
            desc = this.lookupFunction(name, describable);
            if (desc != null) {
                model = this.modelForDescribable(name, describable);
            }
        }
        return model;
    }

    public synchronized DescribableModel<? extends Describable> modelForFunctionFirstThenStep(String name, Class<? extends Describable> describable) {
        StepDescriptor desc = this.lookupFunction(name, describable);
        DescribableModel<? extends Describable> model = null;
        if (desc != null) {
            model = this.modelForDescribable(name, describable);
        } else {
            desc = this.lookupStepDescriptor(name);
            if (desc != null) {
                model = this.modelForStep(name);
            }
        }
        return model;
    }

    public boolean stepTakesClosure(Descriptor d) {
        if (d instanceof StepDescriptor) {
            return ((StepDescriptor)d).takesImplicitBlockArgument();
        }
        return false;
    }
}

