/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStep;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public class ModelASTTreeStep
extends ModelASTStep {
    private List<ModelASTStep> children = new ArrayList<ModelASTStep>();

    public ModelASTTreeStep(Object sourceLocation) {
        super(sourceLocation);
    }

    @Override
    public JSONObject toJSON() {
        JSONArray a = new JSONArray();
        for (ModelASTStep child : this.children) {
            a.add((Object)child.toJSON());
        }
        return super.toJSON().accumulate("children", (Object)a);
    }

    @Override
    public void validate(@Nonnull ModelValidator validator) {
        super.validate(validator);
        for (ModelASTStep child : this.children) {
            child.validate(validator);
        }
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder();
        result.append(super.toGroovy()).append(" {\n");
        for (ModelASTStep child : this.children) {
            result.append(child.toGroovy()).append("\n");
        }
        result.append("}\n");
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        for (ModelASTStep child : this.children) {
            child.removeSourceLocation();
        }
    }

    public List<ModelASTStep> getChildren() {
        return this.children;
    }

    public void setChildren(List<ModelASTStep> children) {
        this.children = children;
    }

    @Override
    public String toString() {
        return "ModelASTTreeStep{name='" + this.getName() + '\'' + ", args=" + this.getArgs() + ", children=" + this.children + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTTreeStep that = (ModelASTTreeStep)o;
        return this.getChildren() != null ? this.getChildren().equals(that.getChildren()) : that.getChildren() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getChildren() != null ? this.getChildren().hashCode() : 0);
        return result;
    }
}

