/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTBuildParameter;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public final class ModelASTBuildParameters
extends ModelASTElement {
    private List<ModelASTBuildParameter> parameters = new ArrayList<ModelASTBuildParameter>();

    public ModelASTBuildParameters(Object sourceLocation) {
        super(sourceLocation);
    }

    public JSONObject toJSON() {
        JSONArray a = new JSONArray();
        for (ModelASTBuildParameter parameter : this.parameters) {
            a.add((Object)parameter.toJSON());
        }
        return new JSONObject().accumulate("parameters", (Object)a);
    }

    @Override
    public void validate(@Nonnull ModelValidator validator) {
        validator.validateElement(this);
        for (ModelASTBuildParameter parameter : this.parameters) {
            parameter.validate(validator);
        }
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder("parameters {\n");
        for (ModelASTBuildParameter parameter : this.parameters) {
            result.append(parameter.toGroovy()).append("\n");
        }
        result.append("}\n");
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        for (ModelASTBuildParameter parameter : this.parameters) {
            parameter.removeSourceLocation();
        }
    }

    public List<ModelASTBuildParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ModelASTBuildParameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    public String toString() {
        return "ModelASTBuildParameters{parameters=" + this.parameters + ", " + super.toString() + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTBuildParameters that = (ModelASTBuildParameters)o;
        return this.getParameters() != null ? this.getParameters().equals(that.getParameters()) : that.getParameters() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getParameters() != null ? this.getParameters().hashCode() : 0);
        return result;
    }
}

