/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTBuildCondition;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public abstract class ModelASTBuildConditionsContainer
extends ModelASTElement {
    private List<ModelASTBuildCondition> conditions = new ArrayList<ModelASTBuildCondition>();

    protected ModelASTBuildConditionsContainer(Object sourceLocation) {
        super(sourceLocation);
    }

    public abstract String getName();

    public JSONObject toJSON() {
        JSONArray a = new JSONArray();
        for (ModelASTBuildCondition condition : this.conditions) {
            a.add((Object)condition.toJSON());
        }
        return new JSONObject().accumulate("conditions", (Object)a);
    }

    @Override
    public void validate(ModelValidator validator) {
        validator.validateElement(this);
        for (ModelASTBuildCondition condition : this.conditions) {
            condition.validate(validator);
        }
        super.validate(validator);
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder(this.getName());
        result.append(" {\n");
        for (ModelASTBuildCondition condition : this.conditions) {
            result.append(condition.toGroovy()).append('\n');
        }
        result.append("}\n");
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        for (ModelASTBuildCondition condition : this.conditions) {
            condition.removeSourceLocation();
        }
    }

    public List<ModelASTBuildCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<ModelASTBuildCondition> conditions) {
        this.conditions = conditions;
    }

    @Override
    public String toString() {
        return "ModelASTBuildConditionsContainer{conditions=" + this.conditions + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTBuildConditionsContainer that = (ModelASTBuildConditionsContainer)o;
        return this.getConditions() != null ? this.getConditions().equals(that.getConditions()) : that.getConditions() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getConditions() != null ? this.getConditions().hashCode() : 0);
        return result;
    }
}

