/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTWhenContent;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public class ModelASTWhen
extends ModelASTElement {
    private List<ModelASTWhenContent> conditions = new ArrayList<ModelASTWhenContent>();

    public ModelASTWhen(Object sourceLocation) {
        super(sourceLocation);
    }

    public List<ModelASTWhenContent> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<ModelASTWhenContent> conditions) {
        this.conditions = conditions;
    }

    @Override
    public Object toJSON() {
        JSONArray a = new JSONArray();
        for (ModelASTWhenContent c : this.conditions) {
            a.add(c.toJSON());
        }
        return new JSONObject().accumulate("conditions", (Object)a);
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder("when {\n");
        for (ModelASTWhenContent c : this.conditions) {
            result.append(c.toGroovy()).append("\n");
        }
        result.append("}\n");
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        for (ModelASTWhenContent c : this.conditions) {
            c.removeSourceLocation();
        }
    }

    @Override
    public String toString() {
        return "ModelASTWhen{conditions=" + this.conditions + "}";
    }

    @Override
    public void validate(ModelValidator validator) {
        validator.validateElement(this);
        for (ModelASTWhenContent c : this.conditions) {
            c.validate(validator);
        }
    }
}

