/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack.youtrackapi;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.youtrack.Command;
import org.jenkinsci.plugins.youtrack.youtrackapi.BuildBundle;
import org.jenkinsci.plugins.youtrack.youtrackapi.Field;
import org.jenkinsci.plugins.youtrack.youtrackapi.Group;
import org.jenkinsci.plugins.youtrack.youtrackapi.Issue;
import org.jenkinsci.plugins.youtrack.youtrackapi.Project;
import org.jenkinsci.plugins.youtrack.youtrackapi.StateBundle;
import org.jenkinsci.plugins.youtrack.youtrackapi.Suggestion;
import org.jenkinsci.plugins.youtrack.youtrackapi.User;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class YouTrackServer {
    private static final Logger LOGGER = Logger.getLogger(YouTrackServer.class.getName());
    private final String serverUrl;

    public YouTrackServer(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    private static String getErrorMessage(InputStream errorStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(errorStream, StandardCharsets.UTF_8));){
            String l;
            while ((l = bufferedReader.readLine()) != null) {
                stringBuilder.append(l).append("\n");
            }
        }
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            ErrorHandler errorHandler = new ErrorHandler();
            saxParser.parse(new InputSource(new StringReader(stringBuilder.toString())), (DefaultHandler)errorHandler);
            return errorHandler.errorMessage;
        }
        catch (ParserConfigurationException | SAXException e) {
            LOGGER.log(Level.WARNING, "Could not parse error response", e);
            return stringBuilder.toString();
        }
    }

    public Command createIssue(String siteName, User user, String project, String title, String description, String command, File attachment) {
        return this.createIssuePOST(siteName, user, project, title, description, command, attachment);
    }

    public List<Group> getGroups(User user) {
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            URL url = new URL(this.serverUrl + "/rest/admin/group");
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            for (String cookie : user.getCookies()) {
                urlConnection.setRequestProperty("Cookie", cookie);
            }
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            try {
                if (urlConnection.getResponseCode() == 200) {
                    SAXParser saxParser = saxParserFactory.newSAXParser();
                    Group.GroupListHandler dh = new Group.GroupListHandler();
                    saxParser.parse(urlConnection.getInputStream(), (DefaultHandler)dh);
                    return dh.getGroups();
                }
            }
            catch (ParserConfigurationException e) {
                LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
            }
            catch (SAXException e) {
                LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
            }
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
        }
        return groups;
    }

    public StateBundle getStateBundleWithName(User user, String stateBundleName) {
        try {
            String stateBundleUrl = this.serverUrl + "/rest/admin/customfield/stateBundle/" + stateBundleName;
            URL url = new URL(stateBundleUrl);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            for (String cookie : user.getCookies()) {
                urlConnection.setRequestProperty("Cookie", cookie);
            }
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            try {
                if (urlConnection.getResponseCode() == 200) {
                    SAXParser saxParser = saxParserFactory.newSAXParser();
                    StateBundle stateBundle = new StateBundle(stateBundleName, stateBundleUrl);
                    StateBundle.StateBundleHandler dh = new StateBundle.StateBundleHandler(stateBundle);
                    saxParser.parse(urlConnection.getInputStream(), (DefaultHandler)dh);
                    return stateBundle;
                }
            }
            catch (ParserConfigurationException e) {
                LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
            }
            catch (SAXException e) {
                LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
            }
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
        }
        return null;
    }

    public StateBundle getStateBundleForField(User user, String fieldName) {
        try {
            String fieldUrl = this.serverUrl + "/rest/admin/customfield/field/" + fieldName;
            URL url = new URL(fieldUrl);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            for (String cookie : user.getCookies()) {
                urlConnection.setRequestProperty("Cookie", cookie);
            }
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            try {
                if (urlConnection.getResponseCode() == 200) {
                    SAXParser saxParser = saxParserFactory.newSAXParser();
                    Field.FieldHandler dh = new Field.FieldHandler(fieldName, fieldUrl);
                    saxParser.parse(urlConnection.getInputStream(), (DefaultHandler)dh);
                    Field field = dh.getField();
                    if (field.getType().equals("state[1]")) {
                        return this.getStateBundleWithName(user, field.getDefaultBundle());
                    }
                    return null;
                }
            }
            catch (ParserConfigurationException e) {
                LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
            }
            catch (SAXException e) {
                LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
            }
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
        }
        return null;
    }

    public String getBuildBundleNameForField(User user, String projectId, String fieldName) {
        try {
            String encodedProjectId = URLEncoder.encode(projectId, "ISO-8859-1").replace("+", "%20");
            String encodedFieldName = URLEncoder.encode(fieldName, "ISO-8859-1").replace("+", "%20");
            String fieldUrl = this.serverUrl + "/rest/admin/project/" + encodedProjectId + "/customfield/" + encodedFieldName;
            URL url = new URL(fieldUrl);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            for (String cookie : user.getCookies()) {
                urlConnection.setRequestProperty("Cookie", cookie);
            }
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            try {
                if (urlConnection.getResponseCode() == 200) {
                    SAXParser saxParser = saxParserFactory.newSAXParser();
                    Field.FieldHandler dh = new Field.FieldHandler(fieldName, fieldUrl);
                    saxParser.parse(urlConnection.getInputStream(), (DefaultHandler)dh);
                    Field field = dh.getField();
                    if (field.getType().equals("build[1]")) {
                        return field.getDefaultBundle();
                    }
                    return null;
                }
            }
            catch (ParserConfigurationException e) {
                LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
            }
            catch (SAXException e) {
                LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
            }
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
        }
        return null;
    }

    public List<Field> getFields(User user) {
        ArrayList<Field> fields = new ArrayList<Field>();
        try {
            URL url = new URL(this.serverUrl + "/rest/admin/customfield/field/");
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            for (String cookie : user.getCookies()) {
                urlConnection.setRequestProperty("Cookie", cookie);
            }
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            try {
                if (urlConnection.getResponseCode() == 200) {
                    SAXParser saxParser = saxParserFactory.newSAXParser();
                    Field.FieldListHandler dh = new Field.FieldListHandler();
                    saxParser.parse(urlConnection.getInputStream(), (DefaultHandler)dh);
                    return dh.getFields();
                }
            }
            catch (ParserConfigurationException e) {
                LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
            }
            catch (SAXException e) {
                LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
            }
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
        }
        return fields;
    }

    public List<Project> getProjects(User user) {
        try {
            URL url = new URL(this.serverUrl + "/rest/project/all");
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            for (String cookie : user.getCookies()) {
                urlConnection.setRequestProperty("Cookie", cookie);
            }
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            try {
                SAXParser saxParser = saxParserFactory.newSAXParser();
                Project.ProjectListHandler dh = new Project.ProjectListHandler();
                saxParser.parse(urlConnection.getInputStream(), (DefaultHandler)dh);
                return dh.getProjects();
            }
            catch (ParserConfigurationException e) {
                LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
            }
            catch (SAXException e) {
                LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
            }
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
        }
        return null;
    }

    public Command comment(String siteName, User user, Issue issue, String comment, String group, boolean silent) {
        Command command = new Command();
        command.setSiteName(siteName);
        command.setIssueId(issue.getId());
        command.setComment(comment);
        command.setDate(new Date());
        command.setGroup(group);
        command.setSilent(silent);
        if (user == null || !user.isLoggedIn()) {
            command.setStatus(Command.Status.NOT_LOGGED_IN);
        } else {
            command.setStatus(Command.Status.FAILED);
        }
        if (user != null) {
            command.setUsername(user.getUsername());
        }
        try {
            URL url = new URL(this.serverUrl + "/rest/issue/" + issue.getId() + "/execute");
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            if (user != null) {
                for (String cookie : user.getCookies()) {
                    urlConnection.setRequestProperty("Cookie", cookie);
                }
            }
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(urlConnection.getOutputStream(), StandardCharsets.UTF_8);){
                outputStreamWriter.write("comment=" + URLEncoder.encode(comment, "UTF-8"));
                if (group != null && !group.equals("")) {
                    outputStreamWriter.write("&group=" + group);
                }
                if (silent) {
                    outputStreamWriter.write("&disableNotifications=true");
                }
                outputStreamWriter.flush();
            }
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 200) {
                command.setStatus(Command.Status.OK);
                return command;
            }
            command.setStatus(Command.Status.FAILED);
            command.setResponse(YouTrackServer.getErrorMessage(urlConnection.getErrorStream()));
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not comment", e);
            command.setResponse(e.getMessage());
        }
        return command;
    }

    public Command applyCommand(String siteName, User user, Issue issue, String command, String comment, String group, User runAs, boolean notify) {
        Command cmd = new Command();
        cmd.setCommand(command);
        cmd.setSilent(!notify);
        cmd.setIssueId(issue.getId());
        cmd.setSiteName(siteName);
        cmd.setDate(new Date());
        cmd.setStatus(Command.Status.FAILED);
        cmd.setComment(comment);
        if (user == null || !user.isLoggedIn()) {
            cmd.setStatus(Command.Status.NOT_LOGGED_IN);
            return cmd;
        }
        cmd.setUsername(user.getUsername());
        try {
            URL url = new URL(this.serverUrl + "/rest/issue/" + issue.getId() + "/execute");
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            for (String cookie : user.getCookies()) {
                urlConnection.setRequestProperty("Cookie", cookie);
            }
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(urlConnection.getOutputStream(), StandardCharsets.UTF_8);){
                String str = "command=" + URLEncoder.encode(command, "UTF-8");
                if (comment != null) {
                    str = str + "&comment=" + URLEncoder.encode(comment, "UTF-8");
                }
                if (runAs != null) {
                    str = str + "&runAs=" + runAs.getUsername();
                }
                if (!notify) {
                    str = str + "&disableNotifications=true";
                }
                if (group != null) {
                    str = str + "&group=" + URLEncoder.encode(group, "UTF-8");
                }
                outputStreamWriter.write(str);
                outputStreamWriter.flush();
            }
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 200) {
                cmd.setStatus(Command.Status.OK);
                return cmd;
            }
            cmd.setStatus(Command.Status.FAILED);
            cmd.setResponse(YouTrackServer.getErrorMessage(urlConnection.getErrorStream()));
            LOGGER.log(Level.WARNING, "Could not apply command: " + cmd.getResponse());
        }
        catch (IOException e) {
            cmd.setResponse(e.getMessage());
            LOGGER.log(Level.WARNING, "Could not apply command", e);
        }
        return cmd;
    }

    public User getUserByEmail(User user, String email) {
        try {
            URL url = new URL(this.serverUrl + "/rest/admin/user?q=" + email);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            for (String cookie : user.getCookies()) {
                urlConnection.setRequestProperty("Cookie", cookie);
            }
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 200) {
                SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                SAXParser saxParser = saxParserFactory.newSAXParser();
                User.UserRefHandler dh = new User.UserRefHandler();
                saxParser.parse(urlConnection.getInputStream(), (DefaultHandler)dh);
                return dh.getUser();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not get user", e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.WARNING, "Could not get user", e);
        }
        catch (SAXException e) {
            LOGGER.log(Level.WARNING, "Could not get user", e);
        }
        return null;
    }

    public User login(String username, String password) {
        try {
            User user = new User();
            user.setUsername(username);
            URL url = new URL(this.serverUrl + "/rest/user/login");
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(urlConnection.getOutputStream(), StandardCharsets.UTF_8);){
                outputStreamWriter.write("login=" + username + "&password=" + password);
                outputStreamWriter.flush();
            }
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 200) {
                Map<String, List<String>> headerFields = urlConnection.getHeaderFields();
                List<String> strings = headerFields.get("Set-Cookie");
                for (String string : strings) {
                    user.getCookies().add(string);
                }
                user.setLoggedIn(true);
                return user;
            }
            return user;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not login", e);
            return null;
        }
    }

    public Command addBuildToBundle(String siteName, User user, String bundleName, String buildName) {
        Command cmd = new Command();
        cmd.setCommand("[Add '" + buildName + "' to " + " '" + bundleName + "']");
        cmd.setDate(new Date());
        cmd.setSiteName(siteName);
        if (user == null || !user.isLoggedIn()) {
            cmd.setStatus(Command.Status.NOT_LOGGED_IN);
            return cmd;
        }
        cmd.setStatus(Command.Status.FAILED);
        user.setUsername(user.getUsername());
        try {
            String encode = URLEncoder.encode(bundleName, "ISO-8859-1").replace("+", "%20");
            String encode1 = URLEncoder.encode(buildName, "ISO-8859-1").replace("+", "%20");
            URL url = new URL(this.serverUrl + "/rest/admin/customfield/buildBundle/" + encode + "/" + encode1);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("PUT");
            for (String cookie : user.getCookies()) {
                urlConnection.setRequestProperty("Cookie", cookie);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(urlConnection.getOutputStream(), StandardCharsets.UTF_8);){
                outputStreamWriter.flush();
            }
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 201) {
                cmd.setStatus(Command.Status.OK);
                return cmd;
            }
            cmd.setStatus(Command.Status.FAILED);
            cmd.setResponse(YouTrackServer.getErrorMessage(urlConnection.getErrorStream()));
        }
        catch (IOException e) {
            cmd.setResponse(e.getMessage());
            LOGGER.log(Level.WARNING, "Could not add to bundle", e);
        }
        return cmd;
    }

    public Issue getIssue(User user, String issueId, String stateField) {
        try {
            URL url = new URL(this.serverUrl + "/rest/issue/" + issueId + "?wikifyDescription=true");
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            for (String cookie : user.getCookies()) {
                urlConnection.setRequestProperty("Cookie", cookie);
            }
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 200) {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser saxParser = factory.newSAXParser();
                    Issue.IssueHandler issueHandler = new Issue.IssueHandler(stateField);
                    saxParser.parse(urlConnection.getInputStream(), (DefaultHandler)issueHandler);
                    return issueHandler.getIssue();
                }
                catch (ParserConfigurationException | SAXException e) {
                    LOGGER.log(Level.WARNING, "Could not get issue", e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not get issue", e);
        }
        return null;
    }

    public String[] getVersion() {
        try {
            URL url = new URL(this.serverUrl + "/rest/workflow/version");
            try {
                HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                if (urlConnection.getResponseCode() == 200) {
                    SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                    SAXParser saxParser = saxParserFactory.newSAXParser();
                    VersionHandler versionHandler = new VersionHandler();
                    saxParser.parse(urlConnection.getInputStream(), (DefaultHandler)versionHandler);
                    return versionHandler.version.split("\\.");
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                LOGGER.log(Level.WARNING, "Could not get version", e);
            }
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, "Wrong url", e);
        }
        return null;
    }

    public List<BuildBundle> getBuildBundles(User user) {
        try {
            URL url = new URL(this.serverUrl + "/rest/admin/customfield/buildBundle");
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            for (String cookie : user.getCookies()) {
                urlConnection.setRequestProperty("Cookie", cookie);
            }
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 200) {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser saxParser = factory.newSAXParser();
                    BuildBundle.Handler issueHandler = new BuildBundle.Handler();
                    saxParser.parse(urlConnection.getInputStream(), (DefaultHandler)issueHandler);
                    return issueHandler.getBundles();
                }
                catch (ParserConfigurationException | SAXException e) {
                    LOGGER.log(Level.WARNING, "Could not get issue", e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not get issue", e);
        }
        return null;
    }

    public List<Issue> search(User user, String searchQuery) {
        try {
            URL url = new URL(this.serverUrl + "/rest/issue?filter=" + URLEncoder.encode(searchQuery, "UTF-8") + "&max=" + Integer.MAX_VALUE);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            for (String cookie : user.getCookies()) {
                urlConnection.setRequestProperty("Cookie", cookie);
            }
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 200) {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser saxParser = factory.newSAXParser();
                    Issue.IssueSearchHandler issueSearchHandler = new Issue.IssueSearchHandler();
                    saxParser.parse(urlConnection.getInputStream(), (DefaultHandler)issueSearchHandler);
                    return issueSearchHandler.getIssueList();
                }
                catch (ParserConfigurationException | SAXException e) {
                    LOGGER.log(Level.WARNING, "Could not find issues", e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not find issues", e);
        }
        return null;
    }

    public List<Suggestion> searchSuggestions(User user, String current) {
        try {
            URL url = new URL(this.serverUrl + "/rest/issue/intellisense?filter=" + URLEncoder.encode(current, "UTF-8"));
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            for (String cookie : user.getCookies()) {
                urlConnection.setRequestProperty("Cookie", cookie);
            }
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 200) {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser saxParser = factory.newSAXParser();
                    Issue.IssueSearchSuggestionHandler issueSearchHandler = new Issue.IssueSearchSuggestionHandler();
                    saxParser.parse(urlConnection.getInputStream(), (DefaultHandler)issueSearchHandler);
                    return issueSearchHandler.getSuggestions();
                }
                catch (ParserConfigurationException | SAXException e) {
                    LOGGER.log(Level.WARNING, "Could not find issues", e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not find issues", e);
        }
        return new ArrayList<Suggestion>();
    }

    private Command createIssuePOST(String siteName, User user, String project, String title, String description, String command, File attachment) {
        Command cmd = new Command();
        cmd.setCommand("[Create issue]");
        cmd.setDate(new Date());
        cmd.setSiteName(siteName);
        if (user == null || !user.isLoggedIn()) {
            cmd.setStatus(Command.Status.NOT_LOGGED_IN);
            return null;
        }
        cmd.setStatus(Command.Status.FAILED);
        try {
            String params = "project=" + URLEncoder.encode(project, "UTF-8") + "&summary=" + URLEncoder.encode(title, "UTF-8") + "&description=" + URLEncoder.encode(description, "UTF-8");
            PostMethod postMethod = new PostMethod(this.serverUrl + "/rest/issue");
            for (String cookie : user.getCookies()) {
                postMethod.addRequestHeader("Cookie", cookie);
            }
            ArrayList<Object> parts = new ArrayList<Object>();
            parts.add(new StringPart("project", project, "UTF-8"));
            parts.add(new StringPart("summary", title, "UTF-8"));
            parts.add(new StringPart("description", description, "UTF-8"));
            if (attachment != null) {
                parts.add(new FilePart("attachment", attachment));
            }
            Part[] partsArray = new Part[]{};
            Part[] array = parts.toArray(partsArray);
            postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(array, new HttpMethodParams()));
            HttpClient httpClient = new HttpClient();
            int responseCode = httpClient.executeMethod((HttpMethod)postMethod);
            if (responseCode == 201 || responseCode == 200) {
                StringBuilder stringBuilder = new StringBuilder();
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(postMethod.getResponseBodyAsStream(), StandardCharsets.UTF_8));){
                    String l = null;
                    while ((l = bufferedReader.readLine()) != null) {
                        stringBuilder.append(l).append("\n");
                    }
                }
                try {
                    SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                    SAXParser saxParser = saxParserFactory.newSAXParser();
                    CreateIssueHandler handler = new CreateIssueHandler();
                    saxParser.parse(new InputSource(new StringReader(stringBuilder.toString())), (DefaultHandler)handler);
                    String issueId = handler.issueId;
                    LOGGER.log(Level.INFO, "Created issue " + issueId);
                    if (issueId != null) {
                        Issue issue = new Issue(issueId);
                        if (StringUtils.isNotBlank((String)command)) {
                            this.applyCommand(siteName, user, issue, command, "", null, null, false);
                            cmd.setCommand(command);
                        }
                        cmd.setIssueId(issueId);
                    }
                }
                catch (RuntimeException e) {
                    cmd.setCommand("[Unable to apply command]");
                }
                catch (Exception e) {
                    cmd.setCommand("[Unable to apply command]");
                }
                cmd.setStatus(Command.Status.OK);
                return cmd;
            }
            cmd.setResponse(YouTrackServer.getErrorMessage(postMethod.getResponseBodyAsStream()));
            LOGGER.log(Level.WARNING, "Did not create issue: " + cmd.getResponse());
        }
        catch (IOException e) {
            cmd.setResponse(e.getMessage());
            LOGGER.log(Level.WARNING, "Did not create issue", e);
        }
        return cmd;
    }

    private static class CreateIssueHandler
    extends DefaultHandler {
        public String issueId;

        private CreateIssueHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("issue")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("id")) continue;
                    this.issueId = attributes.getValue(i);
                    break;
                }
            }
        }
    }

    private static class ErrorHandler
    extends DefaultHandler {
        private StringBuilder stringBuilder = new StringBuilder();
        private boolean inError;
        private String errorMessage;

        private ErrorHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (qName.equals("error")) {
                this.inError = true;
                this.stringBuilder.setLength(0);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (qName.equals("error")) {
                this.errorMessage = this.stringBuilder.toString();
                this.inError = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            if (this.inError) {
                this.stringBuilder.append(ch, start, length);
            }
        }
    }

    private static class VersionHandler
    extends DefaultHandler {
        boolean inVersion = false;
        private StringBuilder stringBuilder = new StringBuilder();
        private String version;

        private VersionHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (qName.equals("version")) {
                this.inVersion = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            if (this.inVersion) {
                this.stringBuilder.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("version")) {
                this.inVersion = false;
                this.version = this.stringBuilder.toString();
            }
            super.endElement(uri, localName, qName);
        }
    }
}

