/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack.youtrackapi;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.youtrack.youtrackapi.State;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StateBundle {
    private final String name;
    private final String url;
    private final List<State> states = new ArrayList<State>();

    @ConstructorProperties(value={"name", "url"})
    public StateBundle(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public List<State> getStates() {
        return this.states;
    }

    public static class StateBundleHandler
    extends DefaultHandler {
        private StateBundle stateBundle;
        private StringBuilder stringBuilder = new StringBuilder();
        boolean inStateValue;
        private State currentState;

        public StateBundleHandler(StateBundle stateBundle) {
            this.stateBundle = stateBundle;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.stringBuilder.setLength(0);
            super.startElement(uri, localName, qName, attributes);
            if (qName.equals("state")) {
                State state;
                this.inStateValue = true;
                this.currentState = state = new State();
                state.setDescription(attributes.getValue("description"));
                state.setResolved(Boolean.valueOf(attributes.getValue("isResolved")));
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            if (this.inStateValue) {
                this.stringBuilder.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (qName.equals("state")) {
                this.currentState.setValue(this.stringBuilder.toString());
                this.stateBundle.states.add(this.currentState);
                this.currentState = null;
            }
        }
    }
}

