/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack.youtrackapi;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Group {
    private final String name;
    private final String url;

    @ConstructorProperties(value={"name", "url"})
    public Group(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public static class GroupListHandler
    extends DefaultHandler {
        private List<Group> groups;

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.groups = new ArrayList<Group>();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (qName.equals("userGroup")) {
                String groupName = attributes.getValue("name");
                String groupUrl = attributes.getValue("url");
                Group group = new Group(groupName, groupUrl);
                this.groups.add(group);
            }
        }

        public List<Group> getGroups() {
            return this.groups;
        }
    }
}

