/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack.test;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestAction;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestObject;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.youtrack.test.YouTrackTestAction;
import org.kohsuke.stapler.DataBoundConstructor;

public class YoutrackTestDataPublisher
extends TestDataPublisher {
    @DataBoundConstructor
    public YoutrackTestDataPublisher() {
    }

    public TestResultAction.Data getTestData(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, TestResult testResult) throws IOException, InterruptedException {
        Data data = new Data(build);
        List failedTests = testResult.getFailedTests();
        for (CaseResult failedTest : failedTests) {
            YouTrackTestAction previousAction;
            CaseResult previousResult = failedTest.getPreviousResult();
            if (previousResult == null || (previousAction = (YouTrackTestAction)((Object)previousResult.getTestAction(YouTrackTestAction.class))) == null || previousAction.getYoutrackIssueId() == null) continue;
            YouTrackTestAction youTrackTestAction = new YouTrackTestAction(data, failedTest, failedTest.getId(), previousAction.getYoutrackIssueId());
            data.addLink(testResult.getId(), youTrackTestAction);
        }
        return data;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<TestDataPublisher> {
        public String getDisplayName() {
            return "Enable manual linking of failed test to Youtrack issues";
        }
    }

    public static class Data
    extends TestResultAction.Data
    implements Saveable {
        private final AbstractBuild<?, ?> build;
        private Map<String, YouTrackTestAction> links = new HashMap<String, YouTrackTestAction>();

        public AbstractBuild<?, ?> getBuild() {
            return this.build;
        }

        public Data(AbstractBuild<?, ?> build) {
            this.build = build;
        }

        public List<TestAction> getTestAction(TestObject testObject) {
            CaseResult caseResult;
            String id = testObject.getId();
            YouTrackTestAction result = this.links.get(id);
            if (result != null) {
                return Collections.singletonList(result);
            }
            if (testObject instanceof CaseResult && !(caseResult = (CaseResult)testObject).isPassed() && !caseResult.isSkipped()) {
                return Collections.singletonList(new YouTrackTestAction(this, caseResult, id, null));
            }
            return Collections.emptyList();
        }

        public void addLink(String id, YouTrackTestAction action) {
            this.links.put(id, action);
        }

        public void save() throws IOException {
            this.build.save();
        }
    }
}

