/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.youtrack.Command;
import org.jenkinsci.plugins.youtrack.Messages;
import org.jenkinsci.plugins.youtrack.YouTrackCommandAction;
import org.jenkinsci.plugins.youtrack.YouTrackProjectProperty;
import org.jenkinsci.plugins.youtrack.YouTrackSite;
import org.jenkinsci.plugins.youtrack.youtrackapi.User;
import org.jenkinsci.plugins.youtrack.youtrackapi.YouTrackServer;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class YoutrackCreateIssueOnBuildFailure
extends Notifier {
    public static final String FAILURE = "failure";
    public static final String FAILUREORUNSTABL = "failureOrUnstable";
    private String project;
    private String summary;
    private String description;
    private String threshold;
    private String visibility;
    private String command;
    private boolean attachBuildLog;

    @DataBoundConstructor
    public YoutrackCreateIssueOnBuildFailure(String project, String summary, String description, String threshold, String visibility, String command, boolean attachBuildLog) {
        this.project = project;
        this.summary = summary;
        this.description = description;
        this.threshold = threshold;
        this.visibility = visibility;
        this.command = command;
        this.attachBuildLog = attachBuildLog;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        YouTrackSite youTrackSite = this.getYouTrackSite(build);
        if (youTrackSite == null) {
            listener.getLogger().println("No YouTrack site configured");
            return true;
        }
        if (this.shouldCreateIssue(build)) {
            YouTrackServer server = this.getYouTrackServer(youTrackSite);
            User user = server.login(youTrackSite.getUsername(), youTrackSite.getPassword());
            if (user == null) {
                listener.getLogger().println("Could not login user to YouTrack");
                return true;
            }
            EnvVars environment = build.getEnvironment((TaskListener)listener);
            String title = environment.expand(this.summary);
            String description = environment.expand(this.description);
            String command = environment.expand(this.command);
            title = title == null || "".equals(title) ? "Build failure in build " + build.getNumber() : environment.expand(title);
            description = description == null || "".equals(description) ? this.getAbsoluteUrl(build) : environment.expand(description);
            File buildLog = null;
            if (this.attachBuildLog) {
                buildLog = build.getLogFile();
            }
            Command issue = server.createIssue(youTrackSite.getName(), user, this.project, title, description, command, buildLog);
            YouTrackCommandAction youTrackCommandAction = (YouTrackCommandAction)build.getAction(YouTrackCommandAction.class);
            if (youTrackCommandAction == null) {
                youTrackCommandAction = new YouTrackCommandAction(build);
                build.addAction((Action)youTrackCommandAction);
            }
            youTrackCommandAction.addCommand(issue);
            listener.getLogger().println("Created new YouTrack issue " + issue.getIssueId());
        }
        return true;
    }

    public String getAbsoluteUrl(AbstractBuild<?, ?> build) {
        return build.getAbsoluteUrl();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    YouTrackServer getYouTrackServer(YouTrackSite youTrackSite) {
        return new YouTrackServer(youTrackSite.getUrl());
    }

    YouTrackSite getYouTrackSite(AbstractBuild<?, ?> build) {
        return YouTrackSite.get(build.getProject());
    }

    private boolean shouldCreateIssue(AbstractBuild<?, ?> build) {
        Result result = build.getResult();
        if (FAILURE.equals(this.threshold) && result.isBetterThan(Result.FAILURE)) {
            return false;
        }
        return !FAILUREORUNSTABL.equals(this.threshold) || !result.isBetterThan(Result.UNSTABLE);
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public void setThreshold(String threshold) {
        this.threshold = threshold;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean isAttachBuildLog() {
        return this.attachBuildLog;
    }

    public void setAttachBuildLog(boolean attachBuildLog) {
        this.attachBuildLog = attachBuildLog;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.create_issue_on_build_failure_header();
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) {
            return (Publisher)req.bindJSON(YoutrackCreateIssueOnBuildFailure.class, formData);
        }

        public FormValidation doCheckProject(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public AutoCompletionCandidates doAutoCompleteProject(@AncestorInPath AbstractProject project, @QueryParameter String value) {
            return YouTrackProjectProperty.getProjects(project, value);
        }
    }
}

