/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.listeners.SCMListener;
import hudson.scm.ChangeLogSet;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import org.jenkinsci.plugins.youtrack.YoutrackIssueUpdater;
import org.jenkinsci.plugins.youtrack.YoutrackUpdateIssuesRecorder;

public class YouTrackSCMListener
extends SCMListener {
    public void onChangeLogParsed(AbstractBuild<?, ?> build, BuildListener listener, ChangeLogSet<?> changeLogSet) throws Exception {
        if (build.getRootBuild().equals(build)) {
            DescribableList publishersList = build.getProject().getPublishersList();
            boolean hasRecorder = false;
            if (publishersList != null) {
                for (Publisher publisher : publishersList) {
                    if (!(publisher instanceof YoutrackUpdateIssuesRecorder)) continue;
                    hasRecorder = true;
                    break;
                }
            }
            if (!hasRecorder) {
                YoutrackIssueUpdater youtrackIssueUpdater = this.getYoutrackIssueUpdater();
                youtrackIssueUpdater.update(build.getProject().getScm(), build, listener, changeLogSet);
            }
        }
    }

    YoutrackIssueUpdater getYoutrackIssueUpdater() {
        return new YoutrackIssueUpdater();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof YouTrackSCMListener;
    }

    public int hashCode() {
        return 1;
    }
}

