/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack;

import com.google.gson.Gson;
import hudson.model.AbstractProject;
import hudson.model.Action;
import java.io.IOException;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.youtrack.YouTrackSite;
import org.jenkinsci.plugins.youtrack.youtrackapi.Issue;
import org.jenkinsci.plugins.youtrack.youtrackapi.User;
import org.jenkinsci.plugins.youtrack.youtrackapi.YouTrackServer;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class YouTrackIssueAction
implements Action {
    public final AbstractProject project;

    public YouTrackIssueAction(AbstractProject project) {
        this.project = project;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "youtrack";
    }

    public HttpResponse doIssue() {
        return new HttpResponse(){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                String id = req.getParameter("id");
                YouTrackSite youTrackSite = YouTrackIssueAction.this.getYouTrackSite();
                if (youTrackSite == null || !youTrackSite.isPluginEnabled()) {
                    rsp.getWriter().write("YouTrack integration not set up for this project");
                    return;
                }
                YouTrackServer youTrackServer = YouTrackIssueAction.this.getYouTrackServer(youTrackSite);
                User user = youTrackServer.login(youTrackSite.getUsername(), youTrackSite.getPassword());
                if (user == null || !user.isLoggedIn()) {
                    rsp.getWriter().write("Could not log in to YouTrack");
                    return;
                }
                Issue issue = youTrackServer.getIssue(user, id, youTrackSite.getStateFieldName());
                Document document = Jsoup.parse((String)issue.getDescription());
                Elements imageElements = document.select("img");
                for (Element imageElement : imageElements) {
                    String src = imageElement.attr("src");
                    if (src.contains("://") || src.startsWith("//")) continue;
                    String url = youTrackSite.getUrl();
                    String host = YouTrackIssueAction.this.getDomainName(url);
                    imageElement.attr("src", host + src);
                }
                issue.setDescription(document.html());
                Gson gson = new Gson();
                String json = gson.toJson((Object)issue);
                rsp.getWriter().write(json);
            }
        };
    }

    YouTrackServer getYouTrackServer(YouTrackSite youTrackSite) {
        return new YouTrackServer(youTrackSite.getUrl());
    }

    YouTrackSite getYouTrackSite() {
        return YouTrackSite.get(this.project);
    }

    private String getDomainName(String url) {
        int slashslash = url.indexOf("//") + 2;
        return url.substring(0, slashslash) + url.substring(slashslash, url.indexOf(47, slashslash));
    }
}

