/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.youtrack.Command;
import org.jenkinsci.plugins.youtrack.YouTrackCommandAction;
import org.jenkinsci.plugins.youtrack.YouTrackProjectProperty;
import org.jenkinsci.plugins.youtrack.YouTrackSaveFixedIssues;
import org.jenkinsci.plugins.youtrack.YouTrackSite;
import org.jenkinsci.plugins.youtrack.youtrackapi.BuildBundle;
import org.jenkinsci.plugins.youtrack.youtrackapi.Issue;
import org.jenkinsci.plugins.youtrack.youtrackapi.User;
import org.jenkinsci.plugins.youtrack.youtrackapi.YouTrackServer;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class YouTrackBuildUpdater
extends Recorder {
    private String name;
    private String buildName;
    private String bundleName;
    private boolean markFixedIfUnstable;
    private boolean onlyAddIfHasFixedIssues;
    private boolean runSilently;
    private String buildUpdateCommand;
    private List<BundleFieldProject> bundles = new ArrayList<BundleFieldProject>();

    @DataBoundConstructor
    public YouTrackBuildUpdater(String name, String bundleName, String buildName, boolean markFixedIfUnstable, boolean onlyAddIfHasFixedIssues, boolean runSilently, String buildUpdateCommand, List<BundleFieldProject> bundles) {
        this.name = name;
        this.bundleName = bundleName;
        this.buildName = buildName;
        this.markFixedIfUnstable = markFixedIfUnstable;
        this.onlyAddIfHasFixedIssues = onlyAddIfHasFixedIssues;
        this.runSilently = runSilently;
        this.buildUpdateCommand = buildUpdateCommand;
        this.bundles = bundles;
        if (buildUpdateCommand == null) {
            this.buildUpdateCommand = "Fixed in build: ${YOUTRACK_BUILD_NAME}";
        }
    }

    @Deprecated
    public String getName() {
        return this.name;
    }

    @Deprecated
    public void setName(String name) {
        this.name = name;
    }

    public String getBuildName() {
        if (this.name != null && this.buildName == null) {
            this.buildName = "${BUILD_NUMBER} (" + this.name + ")";
        }
        return this.buildName;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        YouTrackSite youTrackSite = this.getYouTrackSite(build);
        if (youTrackSite == null || !youTrackSite.isPluginEnabled()) {
            listener.getLogger().println("No YouTrack site configured");
            return true;
        }
        YouTrackSaveFixedIssues action = (YouTrackSaveFixedIssues)build.getAction(YouTrackSaveFixedIssues.class);
        YouTrackCommandAction youTrackCommandAction = (YouTrackCommandAction)build.getAction(YouTrackCommandAction.class);
        if (youTrackCommandAction == null) {
            youTrackCommandAction = new YouTrackCommandAction(build);
            build.addAction((Action)youTrackCommandAction);
        }
        if (this.onlyAddIfHasFixedIssues && (action == null || action.getIssueIds().isEmpty())) {
            listener.getLogger().println("No build to add");
            return true;
        }
        YouTrackServer youTrackServer = this.getYouTrackServer(youTrackSite);
        User user = youTrackServer.login(youTrackSite.getUsername(), youTrackSite.getPassword());
        if (user == null || !user.isLoggedIn()) {
            listener.getLogger().println("FAILED: to log in to youtrack");
            youTrackSite.failed(build);
            return true;
        }
        EnvVars environment = build.getEnvironment((TaskListener)listener);
        String buildName = this.getBuildName() == null || this.getBuildName().equals("") ? String.valueOf(build.getNumber()) : environment.expand(this.getBuildName());
        HashSet<String> bundleNames = new HashSet<String>();
        if (this.bundles != null) {
            for (BundleFieldProject bundleFieldProject : this.bundles) {
                String inputBundleName = youTrackServer.getBuildBundleNameForField(user, bundleFieldProject.getProjectId(), bundleFieldProject.getFieldName());
                if (inputBundleName == null || inputBundleName.isEmpty()) continue;
                bundleNames.add(inputBundleName);
            }
        }
        if (this.bundleName != null && this.bundleName.length() != 0) {
            bundleNames.add(environment.expand(this.getBundleName()));
        }
        for (String bundleName : bundleNames) {
            if (bundleName == null || bundleName.isEmpty()) continue;
            Command addedBuild = youTrackServer.addBuildToBundle(youTrackSite.getName(), user, bundleName, buildName);
            if (addedBuild.getStatus() == Command.Status.OK) {
                listener.getLogger().println("Added build " + buildName + " to bundle: " + bundleName);
            } else {
                listener.getLogger().println("FAILED: adding build " + buildName + " to bundle: " + bundleName);
                youTrackSite.failed(build);
            }
            youTrackCommandAction.addCommand(addedBuild);
        }
        if (action != null) {
            List<String> issueIds = action.getIssueIds();
            Result result = build.getResult();
            if (result != null) {
                boolean stable = result.isBetterOrEqualTo(Result.SUCCESS);
                boolean unstable = result.isBetterOrEqualTo(Result.UNSTABLE);
                if (stable || this.isMarkFixedIfUnstable() && unstable) {
                    for (String issueId : issueIds) {
                        Issue issue = new Issue(issueId);
                        environment.put("YOUTRACK_BUILD_NAME", buildName);
                        String commandValue = environment.expand(this.buildUpdateCommand);
                        Command command = youTrackServer.applyCommand(youTrackSite.getName(), user, issue, commandValue, null, null, null, !this.runSilently);
                        if (command.getStatus() == Command.Status.OK) {
                            listener.getLogger().println("Updated Fixed in build to " + buildName + " for " + issueId);
                        } else {
                            youTrackSite.failed(build);
                            listener.getLogger().println("FAILED: updating Fixed in build to " + buildName + " for " + issueId);
                        }
                        youTrackCommandAction.addCommand(command);
                    }
                }
            }
        }
        return true;
    }

    YouTrackServer getYouTrackServer(YouTrackSite youTrackSite) {
        return new YouTrackServer(youTrackSite.getUrl());
    }

    YouTrackSite getYouTrackSite(AbstractBuild<?, ?> build) {
        return YouTrackSite.get(build.getProject());
    }

    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public boolean isMarkFixedIfUnstable() {
        return this.markFixedIfUnstable;
    }

    public void setMarkFixedIfUnstable(boolean markFixedIfUnstable) {
        this.markFixedIfUnstable = markFixedIfUnstable;
    }

    public boolean isOnlyAddIfHasFixedIssues() {
        return this.onlyAddIfHasFixedIssues;
    }

    public void setOnlyAddIfHasFixedIssues(boolean onlyAddIfHasFixedIssues) {
        this.onlyAddIfHasFixedIssues = onlyAddIfHasFixedIssues;
    }

    public boolean isRunSilently() {
        return this.runSilently;
    }

    public void setRunSilently(boolean runSilently) {
        this.runSilently = runSilently;
    }

    public String getBuildUpdateCommand() {
        return this.buildUpdateCommand;
    }

    public void setBuildUpdateCommand(String buildUpdateCommand) {
        this.buildUpdateCommand = buildUpdateCommand;
    }

    public List<BundleFieldProject> getBundles() {
        return this.bundles;
    }

    public void setBundles(List<BundleFieldProject> bundles) {
        this.bundles = bundles;
    }

    public static class BundleFieldProject {
        private String projectId;
        private String fieldName;

        public BundleFieldProject() {
        }

        @DataBoundConstructor
        public BundleFieldProject(String projectId, String fieldName) {
            this.projectId = projectId;
            this.fieldName = fieldName;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "YouTrack Build Updater";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Publisher)req.bindJSON(YouTrackBuildUpdater.class, formData);
        }

        public AutoCompletionCandidates doAutoCompleteBundleName(@AncestorInPath AbstractProject project, @QueryParameter String value) {
            YouTrackServer youTrackServer;
            User user;
            YouTrackSite youTrackSite = YouTrackSite.get(project);
            AutoCompletionCandidates autoCompletionCandidates = new AutoCompletionCandidates();
            if (youTrackSite != null && (user = (youTrackServer = new YouTrackServer(youTrackSite.getUrl())).login(youTrackSite.getUsername(), youTrackSite.getPassword())) != null) {
                List<BuildBundle> bundles = youTrackServer.getBuildBundles(user);
                for (BuildBundle bundle : bundles) {
                    if (!bundle.getName().toLowerCase().contains(value.toLowerCase())) continue;
                    autoCompletionCandidates.add(bundle.getName());
                }
            }
            return autoCompletionCandidates;
        }

        public AutoCompletionCandidates doAutoCompleteFieldBuildBundleToUpdate(@AncestorInPath AbstractProject project, @QueryParameter String value) {
            return YouTrackProjectProperty.getFields(project, value);
        }

        public AutoCompletionCandidates doAutoCompleteProjectId(@AncestorInPath AbstractProject project, @QueryParameter String value) {
            return YouTrackProjectProperty.getProjects(project, value);
        }

        public AutoCompletionCandidates doAutoCompleteFieldName(@AncestorInPath AbstractProject project, @QueryParameter String value) {
            return YouTrackProjectProperty.getFields(project, value);
        }
    }
}

