/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.threshold;

import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.junit.TestResultSummary;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.threshold.XUnitThreshold;
import org.kohsuke.stapler.DataBoundConstructor;

public class SkippedThreshold
extends XUnitThreshold {
    @DataBoundConstructor
    public SkippedThreshold() {
    }

    @Override
    public Result getResultThresholdNumber(XUnitLog log, Run<?, ?> build, TestResultSummary testResult, TestResultSummary previousTestResultAction) {
        int skipCount = testResult.getSkipCount();
        int previousSkipCount = 0;
        if (previousTestResultAction != null) {
            previousSkipCount = previousTestResultAction.getSkipCount();
        }
        int newSkipCount = skipCount - previousSkipCount;
        return this.getResultThresholdNumber(log, skipCount, newSkipCount);
    }

    @Override
    public Result getResultThresholdPercent(XUnitLog log, Run<?, ?> build, TestResultSummary testResult, TestResultSummary previousTestResultAction) {
        int count = testResult.getTotalCount();
        int skippedCount = testResult.getSkipCount();
        int percentSkipped = count == 0 ? 0 : skippedCount * 100 / count;
        int previousSkippedCount = 0;
        if (previousTestResultAction != null) {
            previousSkippedCount = previousTestResultAction.getSkipCount();
        }
        int newSkippedCount = skippedCount - previousSkippedCount;
        int percentNewSkipped = count == 0 ? 0 : newSkippedCount * 100 / count;
        return this.getResultThresholdPercent(log, percentSkipped, percentNewSkipped);
    }

    @Override
    public boolean isValidThreshold(double threshold, double value) {
        return value <= threshold;
    }
}

