/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.threshold;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.junit.TestResultSummary;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.threshold.Messages;
import org.jenkinsci.plugins.xunit.threshold.XUnitThresholdDescriptor;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class XUnitThreshold
implements ExtensionPoint,
Serializable,
Describable<XUnitThreshold> {
    private String unstableThreshold;
    private String unstableNewThreshold;
    private String failureThreshold;
    private String failureNewThreshold;

    protected XUnitThreshold() {
    }

    public XUnitThreshold(String unstableThreshold, String unstableNewThreshold, String failureThreshold, String failureNewThreshold) {
        this.setUnstableThreshold(unstableThreshold);
        this.setUnstableNewThreshold(unstableNewThreshold);
        this.setFailureThreshold(failureThreshold);
        this.setFailureNewThreshold(failureNewThreshold);
    }

    public Descriptor<XUnitThreshold> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    public static DescriptorExtensionList<XUnitThreshold, XUnitThresholdDescriptor<?>> all() {
        return Jenkins.get().getDescriptorList(XUnitThreshold.class);
    }

    public String getUnstableThreshold() {
        return this.unstableThreshold;
    }

    @DataBoundSetter
    public void setUnstableThreshold(String unstableThreshold) {
        this.unstableThreshold = Util.fixEmptyAndTrim((String)unstableThreshold);
    }

    public String getUnstableNewThreshold() {
        return this.unstableNewThreshold;
    }

    @DataBoundSetter
    public void setUnstableNewThreshold(String unstableNewThreshold) {
        this.unstableNewThreshold = Util.fixEmptyAndTrim((String)unstableNewThreshold);
    }

    public String getFailureThreshold() {
        return this.failureThreshold;
    }

    @DataBoundSetter
    public void setFailureThreshold(String failureThreshold) {
        this.failureThreshold = Util.fixEmptyAndTrim((String)failureThreshold);
    }

    public String getFailureNewThreshold() {
        return this.failureNewThreshold;
    }

    @DataBoundSetter
    public void setFailureNewThreshold(String failureNewThreshold) {
        this.failureNewThreshold = Util.fixEmptyAndTrim((String)failureNewThreshold);
    }

    public abstract Result getResultThresholdNumber(XUnitLog var1, Run<?, ?> var2, TestResultSummary var3, TestResultSummary var4);

    public abstract Result getResultThresholdPercent(XUnitLog var1, Run<?, ?> var2, TestResultSummary var3, TestResultSummary var4);

    public abstract boolean isValidThreshold(double var1, double var3);

    public Result getResultThresholdNumber(XUnitLog log, int testCount, int newTestCount) {
        String thresholdName = this.getDescriptor().getDisplayName();
        if (this.isValid(this.getFailureThreshold()) && !this.isValidThreshold(this.asInteger(this.getFailureThreshold()), testCount)) {
            log.info(Messages.XUnitThreshold_threshold_message(thresholdName, Messages.XUnitThreshold_failureThreshold_name()));
            return Result.FAILURE;
        }
        if (this.isValid(this.getFailureNewThreshold()) && !this.isValidThreshold(this.asInteger(this.getFailureNewThreshold()), newTestCount)) {
            log.info(Messages.XUnitThreshold_newThreshold_message(thresholdName, Messages.XUnitThreshold_failureNewThreshold_name()));
            return Result.FAILURE;
        }
        if (this.isValid(this.getUnstableThreshold()) && !this.isValidThreshold(this.asInteger(this.getUnstableThreshold()), testCount)) {
            log.info(Messages.XUnitThreshold_threshold_message(thresholdName, Messages.XUnitThreshold_unstableThreshold_name()));
            return Result.UNSTABLE;
        }
        if (this.isValid(this.getUnstableNewThreshold()) && !this.isValidThreshold(this.asInteger(this.getUnstableNewThreshold()), newTestCount)) {
            log.info(Messages.XUnitThreshold_newThreshold_message(thresholdName, Messages.XUnitThreshold_unstableNewThreshold_name()));
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }

    public Result getResultThresholdPercent(XUnitLog log, double testPercent, double newTestPercent) {
        String thresholdName = this.getDescriptor().getDisplayName();
        if (this.isValid(this.getFailureThreshold()) && !this.isValidThreshold(this.asInteger(this.getFailureThreshold()), testPercent)) {
            log.info(Messages.XUnitThreshold_threshold_message(thresholdName, Messages.XUnitThreshold_failureThreshold_name()));
            return Result.FAILURE;
        }
        if (this.isValid(this.getFailureNewThreshold()) && !this.isValidThreshold(this.asInteger(this.getFailureNewThreshold()), newTestPercent)) {
            log.info(Messages.XUnitThreshold_newThreshold_message(thresholdName, Messages.XUnitThreshold_failureNewThreshold_name()));
            return Result.FAILURE;
        }
        if (this.isValid(this.getUnstableThreshold()) && !this.isValidThreshold(this.asInteger(this.getUnstableThreshold()), testPercent)) {
            log.info(Messages.XUnitThreshold_threshold_message(thresholdName, Messages.XUnitThreshold_unstableThreshold_name()));
            return Result.UNSTABLE;
        }
        if (this.isValid(this.getUnstableNewThreshold()) && !this.isValidThreshold(this.asInteger(this.getUnstableNewThreshold()), newTestPercent)) {
            log.info(Messages.XUnitThreshold_newThreshold_message(thresholdName, Messages.XUnitThreshold_unstableNewThreshold_name()));
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }

    private int asInteger(String threshold) {
        return Integer.parseInt(threshold);
    }

    private boolean isValid(String threshold) {
        if (threshold == null) {
            return false;
        }
        try {
            Integer.parseInt(threshold);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

