/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.service;

import hudson.remoting.VirtualChannel;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.lib.dtkit.util.validator.ValidationError;
import org.jenkinsci.plugins.xunit.service.EmptyReportFileException;
import org.jenkinsci.plugins.xunit.service.Messages;
import org.jenkinsci.plugins.xunit.service.TransformerException;
import org.jenkinsci.plugins.xunit.service.XUnitConversionService;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.service.XUnitReportProcessorService;
import org.jenkinsci.plugins.xunit.service.XUnitToolInfo;
import org.jenkinsci.plugins.xunit.service.XUnitValidationService;

public class XUnitTransformerCallable
extends MasterToSlaveFileCallable<Integer> {
    private static final long serialVersionUID = -8111801428220302087L;
    private XUnitReportProcessorService xUnitReportProcessorService;
    private XUnitConversionService xUnitConversionService;
    private XUnitValidationService xUnitValidationService;
    private XUnitToolInfo xUnitToolInfo;
    private XUnitLog xUnitLog;
    private String processorId;

    @Inject
    public XUnitTransformerCallable(XUnitReportProcessorService xUnitReportProcessorService, XUnitConversionService xUnitConversionService, XUnitValidationService xUnitValidationService, XUnitToolInfo xUnitToolInfo, XUnitLog xUnitLog) {
        this.xUnitReportProcessorService = xUnitReportProcessorService;
        this.xUnitValidationService = xUnitValidationService;
        this.xUnitConversionService = xUnitConversionService;
        this.xUnitToolInfo = xUnitToolInfo;
        this.xUnitLog = xUnitLog;
    }

    public Integer invoke(File ws, VirtualChannel channel) throws IOException, InterruptedException {
        int processedFiles = 0;
        File junitOutputDir = new File(ws, "generatedJUnitFiles");
        if (this.processorId != null) {
            junitOutputDir = new File(junitOutputDir, this.processorId);
        }
        FileUtils.forceMkdir((File)junitOutputDir);
        String metricName = this.xUnitToolInfo.getInputMetric().getToolName();
        String[] resultFiles = this.xUnitReportProcessorService.findReports(ws, this.xUnitToolInfo);
        this.xUnitReportProcessorService.checkIfFindsFilesNewFiles(this.xUnitToolInfo, resultFiles, ws);
        boolean isStopProcessingIfError = this.xUnitReportProcessorService.isStopProcessingIfError(this.xUnitToolInfo);
        for (String curFileName : resultFiles) {
            String msg;
            File curFile = this.xUnitReportProcessorService.getCurrentReport(ws, curFileName);
            if (!this.xUnitValidationService.checkFileIsNotEmpty(curFile)) {
                msg = Messages.XUnitTransformerCallable_empty(curFile.getPath(), metricName);
                if (isStopProcessingIfError) {
                    throw new EmptyReportFileException(msg);
                }
                this.xUnitLog.warn(msg);
                continue;
            }
            if (!this.xUnitValidationService.validateInputFile(this.xUnitToolInfo, curFile)) {
                msg = Messages.XUnitTransformerCallable_invalidInput(curFile, metricName);
                if (isStopProcessingIfError) {
                    throw new TransformerException(msg);
                }
                this.xUnitLog.warn(msg);
                continue;
            }
            File junitTargetFile = this.xUnitConversionService.convert(this.xUnitToolInfo, curFile, junitOutputDir);
            if (!this.xUnitValidationService.validateOutputFile(this.xUnitToolInfo, curFile, junitTargetFile)) {
                for (ValidationError validatorError : this.xUnitToolInfo.getInputMetric().getOutputValidationErrors()) {
                    this.xUnitLog.error(validatorError.getMessage());
                }
                if (isStopProcessingIfError) {
                    String msg2 = Messages.XUnitTransformerCallable_invalidOutput(curFile, metricName);
                    throw new TransformerException(msg2);
                }
            }
            if (++processedFiles % 50 != 0 || this.xUnitToolInfo.getSleepTime() <= 0L) continue;
            Thread.sleep(this.xUnitToolInfo.getSleepTime());
        }
        return processedFiles;
    }

    public String getProcessorId() {
        return this.processorId;
    }

    public void setProcessorId(String processorId) {
        this.processorId = processorId;
    }
}

