/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit;

import java.io.Serializable;

public class ExtraConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long testTimeMargin;
    private long sleepTime;
    private boolean reduceLog;
    private Boolean followSymlink;

    static ExtraConfigurationBuilder withConfiguration(ExtraConfiguration configuration) {
        return new ExtraConfigurationBuilder(configuration);
    }

    public ExtraConfiguration(long testTimeMargin, boolean reduceLog, long sleepTime, boolean followSymlink) {
        this.testTimeMargin = testTimeMargin;
        this.sleepTime = sleepTime;
        this.reduceLog = reduceLog;
        this.followSymlink = followSymlink;
    }

    public long getTestTimeMargin() {
        return this.testTimeMargin;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public boolean isReduceLog() {
        return this.reduceLog;
    }

    public boolean isFollowSymlink() {
        return this.followSymlink;
    }

    private Object readResolve() {
        if (this.followSymlink == null) {
            this.followSymlink = true;
        }
        return this;
    }

    static class ExtraConfigurationBuilder {
        private ExtraConfiguration configuration;

        public ExtraConfigurationBuilder(ExtraConfiguration configuration) {
            this.configuration = new ExtraConfiguration(configuration.testTimeMargin, configuration.reduceLog, configuration.sleepTime, configuration.followSymlink);
        }

        public ExtraConfigurationBuilder testTimeMargin(long testTimeMargin) {
            this.configuration.testTimeMargin = testTimeMargin;
            return this;
        }

        public ExtraConfigurationBuilder sleepTime(long sleepTime) {
            this.configuration.sleepTime = sleepTime;
            return this;
        }

        public ExtraConfigurationBuilder reduceLog(boolean reduceLog) {
            this.configuration.reduceLog = reduceLog;
            return this;
        }

        public ExtraConfigurationBuilder followSymlink(boolean followSymlink) {
            this.configuration.followSymlink = followSymlink;
            return this;
        }

        public ExtraConfiguration build() {
            return this.configuration;
        }
    }
}

