/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.pipeline;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.junit.TestResultSummary;
import hudson.tasks.junit.pipeline.JUnitResultsStepExecution;
import hudson.tasks.test.PipelineTestDetails;
import java.util.List;
import javax.annotation.Nonnull;
import org.jenkinsci.lib.dtkit.type.TestType;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.jenkinsci.plugins.xunit.ExtraConfiguration;
import org.jenkinsci.plugins.xunit.XUnitProcessor;
import org.jenkinsci.plugins.xunit.pipeline.Messages;
import org.jenkinsci.plugins.xunit.pipeline.XUnitResultsStep;
import org.jenkinsci.plugins.xunit.threshold.XUnitThreshold;

public class XUnitResultsStepExecution
extends SynchronousStepExecution<TestResultSummary> {
    private transient XUnitResultsStep step;
    private static final long serialVersionUID = 1L;

    public XUnitResultsStepExecution(@Nonnull XUnitResultsStep step, @Nonnull StepContext context) {
        super(context);
        this.step = step;
    }

    protected TestResultSummary run() throws Exception {
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        workspace.mkdirs();
        Run run = (Run)this.getContext().get(Run.class);
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        FlowNode node = (FlowNode)this.getContext().get(FlowNode.class);
        Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
        String nodeId = node.getId();
        if (this.step.getTools().isEmpty()) {
            throw new AbortException(Messages.XUnitResultsStepExecution_noTool());
        }
        XUnitProcessor xUnitProcessor = new XUnitProcessor(this.step.getTools().toArray(new TestType[0]), this.step.getThresholds().toArray(new XUnitThreshold[0]), this.step.getThresholdMode(), new ExtraConfiguration(this.step.getTestTimeMarginAsLong()));
        List enclosingBlocks = JUnitResultsStepExecution.getEnclosingStagesAndParallels((FlowNode)node);
        PipelineTestDetails pipelineTestDetails = new PipelineTestDetails();
        pipelineTestDetails.setNodeId(nodeId);
        pipelineTestDetails.setEnclosingBlocks(JUnitResultsStepExecution.getEnclosingBlockIds((List)enclosingBlocks));
        pipelineTestDetails.setEnclosingBlockNames(JUnitResultsStepExecution.getEnclosingBlockNames((List)enclosingBlocks));
        xUnitProcessor.process(run, workspace, listener, launcher, this.step.getTestDataPublishers(), pipelineTestDetails);
        TestResultAction action = (TestResultAction)run.getAction(TestResultAction.class);
        if (action != null) {
            Result procResult = xUnitProcessor.getBuildStatus(action.getResult().getResultByNode(nodeId), run);
            Result runResult = run.getResult();
            if (runResult == null) {
                runResult = Result.SUCCESS;
            }
            if (procResult.isWorseThan(runResult)) {
                run.setResult(procResult);
            }
            return new TestResultSummary(action.getResult().getResultByNode(nodeId));
        }
        return new TestResultSummary();
    }
}

