/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.threshold;

import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.junit.TestResult;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.threshold.XUnitThreshold;
import org.kohsuke.stapler.DataBoundConstructor;

public class PassedThreshold
extends XUnitThreshold {
    @DataBoundConstructor
    public PassedThreshold() {
    }

    @Override
    public Result getResultThresholdNumber(XUnitLog log, Run<?, ?> build, TestResult testResultAction, TestResult previousTestResultAction) {
        int passedCount = testResultAction.getPassCount();
        int previousPassedCount = 0;
        if (previousTestResultAction != null) {
            previousPassedCount = previousTestResultAction.getPassCount();
        }
        int newPassedCount = passedCount - previousPassedCount;
        return this.getResultThresholdNumber(log, passedCount, newPassedCount);
    }

    @Override
    public Result getResultThresholdPercent(XUnitLog log, Run<?, ?> build, TestResult testResultAction, TestResult previousTestResultAction) {
        double count = testResultAction.getTotalCount();
        double passedCount = testResultAction.getPassCount();
        double percentPassed = passedCount / count * 100.0;
        double previousPassedCount = 0.0;
        if (previousTestResultAction != null) {
            previousPassedCount = previousTestResultAction.getPassCount();
        }
        double newPassedCount = passedCount - previousPassedCount;
        double percentNewPassed = newPassedCount / count * 100.0;
        return this.getResultThresholdPercent(log, percentPassed, percentNewPassed);
    }

    @Override
    public boolean isValidThreshold(double threshold, double value) {
        return value >= threshold;
    }
}

