/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.service;

import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.jenkinsci.lib.dtkit.model.InputMetric;
import org.jenkinsci.lib.dtkit.model.InputMetricXSL;
import org.jenkinsci.lib.dtkit.util.converter.ConversionException;
import org.jenkinsci.plugins.xunit.exception.XUnitException;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.service.XUnitToolInfo;
import org.jenkinsci.plugins.xunit.types.CustomInputMetric;

public class XUnitConversionService
implements Serializable {
    private XUnitLog xUnitLog;

    @Inject
    public XUnitConversionService(XUnitLog xUnitLog) {
        this.xUnitLog = xUnitLog;
    }

    public File convert(XUnitToolInfo xUnitToolInfo, File inputFile, File junitOutputDirectory) throws XUnitException {
        InputMetric inputMetric = xUnitToolInfo.getInputMetric();
        File parent = new File(junitOutputDirectory, inputMetric.getToolName());
        if (!parent.exists() && !parent.mkdirs()) {
            throw new XUnitException("Can't create " + parent);
        }
        File junitTargetFile = this.getTargetFile(parent);
        try {
            if (inputMetric instanceof CustomInputMetric) {
                return this.convertCustomInputMetric(xUnitToolInfo, inputFile, inputMetric, junitTargetFile);
            }
            if (inputMetric instanceof InputMetricXSL) {
                return this.convertInputMetricXSL(xUnitToolInfo, inputFile, inputMetric, junitTargetFile);
            }
            inputMetric.convert(inputFile, junitTargetFile);
            return junitTargetFile;
        }
        catch (ConversionException e) {
            Throwable cause = e.getCause();
            throw new XUnitException("Conversion error: " + (cause != null ? cause.getMessage() : e.getMessage()));
        }
        catch (IOException | InterruptedException e) {
            throw new XUnitException("Conversion error: " + e.getMessage(), e);
        }
    }

    private File getTargetFile(File parent) {
        String uniqueTestName = UUID.randomUUID().toString();
        return new File(parent, "TEST-" + uniqueTestName + ".xml");
    }

    private File convertCustomInputMetric(XUnitToolInfo xUnitToolInfo, File inputFile, InputMetric inputMetric, File junitTargetFile) {
        CustomInputMetric customInputMetric = (CustomInputMetric)inputMetric;
        customInputMetric.setCustomXSLFile(new File(xUnitToolInfo.getCusXSLFile().getRemote()));
        inputMetric.convert(inputFile, junitTargetFile);
        return junitTargetFile;
    }

    private File convertInputMetricXSL(XUnitToolInfo xUnitToolInfo, File inputFile, InputMetric inputMetric, File junitTargetFile) throws IOException, InterruptedException {
        InputMetricXSL inputMetricXSL = (InputMetricXSL)inputMetric;
        FilePath userXSLFilePath = xUnitToolInfo.getUserContentRoot().child(inputMetricXSL.getUserContentXSLDirRelativePath());
        if (userXSLFilePath.exists()) {
            this.xUnitLog.info("Using the native embedded stylesheet in JENKINS_HOME.");
            try {
                return this.convertInputMetricXSLWithUserXSL(inputFile, junitTargetFile, inputMetricXSL, userXSLFilePath);
            }
            catch (XUnitException xe) {
                this.xUnitLog.error("Error occurs on the use of the user stylesheet: " + xe.getMessage());
                this.xUnitLog.info("Trying to use the native embedded stylesheet.");
                inputMetric.convert(inputFile, junitTargetFile);
                return junitTargetFile;
            }
        }
        inputMetric.convert(inputFile, junitTargetFile);
        return junitTargetFile;
    }

    private File convertInputMetricXSLWithUserXSL(File inputFile, File junitTargetFile, InputMetricXSL inputMetricXSL, FilePath userXSLFilePath) throws XUnitException {
        try {
            List filePathList = userXSLFilePath.list();
            if (filePathList.isEmpty()) {
                throw new XUnitException(String.format("There are no XSLs in '%s'", userXSLFilePath.getRemote()));
            }
            for (FilePath file : userXSLFilePath.list()) {
                if (file.isDirectory()) continue;
                inputMetricXSL.convert(inputFile, junitTargetFile, file.readToString(), null);
                return junitTargetFile;
            }
            throw new XUnitException(String.format("There are no XSLs in '%s'", userXSLFilePath.getRemote()));
        }
        catch (IOException | InterruptedException e) {
            throw new XUnitException("Error in the use of the user stylesheet", e);
        }
    }
}

