/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit;

import com.thalesgroup.dtkit.metrics.hudson.api.descriptor.TestTypeDescriptor;
import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import org.jenkinsci.plugins.xunit.Messages;
import org.jenkinsci.plugins.xunit.XUnitProcessor;
import org.jenkinsci.plugins.xunit.threshold.FailedThreshold;
import org.jenkinsci.plugins.xunit.threshold.SkippedThreshold;
import org.jenkinsci.plugins.xunit.threshold.XUnitThreshold;
import org.jenkinsci.plugins.xunit.threshold.XUnitThresholdDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitBuilder
extends Builder {
    private TestType[] types;
    private XUnitThreshold[] thresholds;
    private int thresholdMode;
    private XUnitProcessor xUnitProcessor;

    public XUnitBuilder(TestType[] types, XUnitThreshold[] thresholds) {
        this.types = types;
        this.thresholds = thresholds;
        this.thresholdMode = 1;
    }

    @DataBoundConstructor
    public XUnitBuilder(TestType[] tools, XUnitThreshold[] thresholds, int thresholdMode) {
        this.types = tools;
        this.thresholds = thresholds;
        this.thresholdMode = thresholdMode;
    }

    public TestType[] getTypes() {
        return this.types;
    }

    public XUnitThreshold[] getThresholds() {
        return this.thresholds;
    }

    public int getThresholdMode() {
        return this.thresholdMode;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        XUnitProcessor xUnitProcessor = new XUnitProcessor(this.types, this.thresholds, this.thresholdMode);
        return xUnitProcessor.performXUnit(false, build, listener);
    }

    public boolean performDryRun(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        try {
            XUnitProcessor xUnitProcessor = new XUnitProcessor(this.types, this.thresholds, this.thresholdMode);
            xUnitProcessor.performXUnit(true, build, listener);
        }
        catch (Throwable t) {
            listener.getLogger().println("[ERROR] - There is an error: " + t.getCause().getMessage());
        }
        build.setResult(Result.SUCCESS);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class XUnitDescriptorBuilder
    extends BuildStepDescriptor<Builder> {
        public XUnitDescriptorBuilder() {
            super(XUnitBuilder.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.xUnit_BuilderName();
        }

        public boolean isApplicable(Class type) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/xunit/help.html";
        }

        public DescriptorExtensionList<TestType, TestTypeDescriptor<?>> getListXUnitTypeDescriptors() {
            return TestTypeDescriptor.all();
        }

        public DescriptorExtensionList<XUnitThreshold, XUnitThresholdDescriptor<?>> getListXUnitThresholdDescriptors() {
            return XUnitThresholdDescriptor.all();
        }

        public XUnitThreshold[] getListXUnitThresholdInstance() {
            return new XUnitThreshold[]{new FailedThreshold(), new SkippedThreshold()};
        }
    }
}

