/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.threshold;

import com.thalesgroup.hudson.plugins.xunit.service.XUnitLog;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.AbstractBuild;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.tasks.junit.TestResultAction;
import java.io.Serializable;
import org.jenkinsci.plugins.xunit.threshold.XUnitThresholdDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XUnitThreshold
implements ExtensionPoint,
Serializable,
Describable<XUnitThreshold> {
    private String unstableThreshold;
    private String unstableNewThreshold;
    private String failureThreshold;
    private String failureNewThreshold;

    protected XUnitThreshold() {
    }

    public XUnitThreshold(String unstableThreshold, String unstableNewThreshold, String failureThreshold, String failureNewThreshold) {
        this.unstableThreshold = unstableThreshold;
        this.unstableNewThreshold = unstableNewThreshold;
        this.failureThreshold = failureThreshold;
        this.failureNewThreshold = failureNewThreshold;
    }

    public Descriptor<XUnitThreshold> getDescriptor() {
        return (XUnitThresholdDescriptor)Hudson.getInstance().getDescriptor(this.getClass());
    }

    public static DescriptorExtensionList<XUnitThreshold, XUnitThresholdDescriptor<?>> all() {
        return Hudson.getInstance().getDescriptorList(XUnitThreshold.class);
    }

    public String getUnstableThreshold() {
        return this.unstableThreshold;
    }

    public String getUnstableNewThreshold() {
        return this.unstableNewThreshold;
    }

    public String getFailureThreshold() {
        return this.failureThreshold;
    }

    public String getFailureNewThreshold() {
        return this.failureNewThreshold;
    }

    public abstract Result getResultThresholdNumber(XUnitLog var1, AbstractBuild<?, ?> var2, TestResultAction var3, TestResultAction var4);

    public abstract Result getResultThresholdPercent(XUnitLog var1, AbstractBuild<?, ?> var2, TestResultAction var3, TestResultAction var4);

    public Result getResultThresholdNumber(XUnitLog log, int testCount, int newTestCount) {
        if (this.isValid(this.getFailureThreshold()) && this.convertToInteger(this.getFailureThreshold()) < testCount) {
            log.infoConsoleLogger("The total number of tests for this category exceeds the specified 'failure' threshold value.");
            return Result.FAILURE;
        }
        if (this.isValid(this.getUnstableNewThreshold()) && this.convertToInteger(this.getFailureNewThreshold()) < newTestCount) {
            log.infoConsoleLogger("The new number of tests for this category exceeds the specified 'new failure' threshold value.");
            return Result.FAILURE;
        }
        if (this.isValid(this.getUnstableThreshold()) && this.convertToInteger(this.getUnstableThreshold()) < testCount) {
            log.infoConsoleLogger("The total number of tests for this category exceeds the specified 'unstable' threshold value.");
            return Result.UNSTABLE;
        }
        if (this.isValid(this.getUnstableNewThreshold()) && this.convertToInteger(this.getUnstableNewThreshold()) < newTestCount) {
            log.infoConsoleLogger("The new number of tests for this category exceeds the specified 'new unstable' threshold value.");
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }

    public Result getResultThresholdPercent(XUnitLog log, double testPercent, double newTestPercent) {
        if (this.isValid(this.getFailureThreshold()) && (double)this.convertToIntegerPercent(this.getFailureThreshold()) < testPercent) {
            log.infoConsoleLogger("The percent of the total number of tests for this category exceeds the specified 'failure' threshold percent value.");
            return Result.FAILURE;
        }
        if (this.isValid(this.getUnstableNewThreshold()) && (double)this.convertToIntegerPercent(this.getFailureNewThreshold()) < newTestPercent) {
            log.infoConsoleLogger("The percent of the new number of tests for this category exceeds the specified 'new failure' threshold percent value.");
            return Result.FAILURE;
        }
        if (this.isValid(this.getUnstableThreshold()) && (double)this.convertToIntegerPercent(this.getUnstableThreshold()) < testPercent) {
            log.infoConsoleLogger("The percent of tests for this category exceeds the specified 'unstable' threshold percent value.");
            return Result.UNSTABLE;
        }
        if (this.isValid(this.getUnstableNewThreshold()) && (double)this.convertToIntegerPercent(this.getUnstableNewThreshold()) < newTestPercent) {
            log.infoConsoleLogger("The percent of the new number of tests for this category exceeds the specified 'new unstable' threshold percent value.");
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }

    private int convertToInteger(String threshold) {
        return Integer.parseInt(threshold);
    }

    private int convertToIntegerPercent(String threshold) {
        String thresholdRemoved = threshold.replace("%", "");
        return Integer.parseInt(thresholdRemoved);
    }

    private boolean isValid(String threshold) {
        if (threshold == null) {
            return false;
        }
        if (threshold.trim().length() == 0) {
            return false;
        }
        try {
            Integer.parseInt(threshold);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

