/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit.service;

import com.google.inject.Inject;
import com.thalesgroup.dtkit.metrics.model.InputMetric;
import com.thalesgroup.dtkit.util.validator.ValidationError;
import com.thalesgroup.dtkit.util.validator.ValidationException;
import com.thalesgroup.hudson.plugins.xunit.exception.XUnitException;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitLog;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitService;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitToolInfo;
import java.io.File;
import java.io.Serializable;

public class XUnitValidationService
extends XUnitService
implements Serializable {
    private XUnitLog xUnitLog;

    @Inject
    void load(XUnitLog xUnitLog) {
        this.xUnitLog = xUnitLog;
    }

    public boolean checkFileIsNotEmpty(File inputFile) {
        return inputFile.length() != 0L;
    }

    public boolean validateInputFile(XUnitToolInfo xUnitToolInfo, File inputFile) throws XUnitException {
        InputMetric inputMetric = xUnitToolInfo.getTestType().getInputMetric();
        try {
            if (!inputMetric.validateInputFile(inputFile)) {
                this.warningSystemLogger("The file '" + inputFile + "' is an invalid file.");
                for (ValidationError validatorError : inputMetric.getInputValidationErrors()) {
                    this.warningSystemLogger(validatorError.toString());
                }
                return false;
            }
        }
        catch (ValidationException ve) {
            throw new XUnitException("Validation error on input", ve);
        }
        return true;
    }

    public boolean validateOutputFile(XUnitToolInfo xUnitToolInfo, File inputFile, File junitTargetFile) throws XUnitException {
        InputMetric inputMetric = xUnitToolInfo.getTestType().getInputMetric();
        try {
            boolean validateOutput = inputMetric.validateOutputFile(junitTargetFile);
            if (!validateOutput) {
                this.warningSystemLogger("The converted file for the input file '" + inputFile + "' doesn't match the JUnit format");
                for (ValidationError validatorError : inputMetric.getOutputValidationErrors()) {
                    this.warningSystemLogger(validatorError.toString());
                }
                return false;
            }
        }
        catch (ValidationException ve) {
            throw new XUnitException("Validation error on output", ve);
        }
        return true;
    }
}

