/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.lib.dtkit.descriptor.TestTypeDescriptor;
import org.jenkinsci.lib.dtkit.type.TestType;
import org.jenkinsci.plugins.xunit.ExtraConfiguration;
import org.jenkinsci.plugins.xunit.Messages;
import org.jenkinsci.plugins.xunit.XUnitProcessor;
import org.jenkinsci.plugins.xunit.threshold.FailedThreshold;
import org.jenkinsci.plugins.xunit.threshold.SkippedThreshold;
import org.jenkinsci.plugins.xunit.threshold.XUnitThreshold;
import org.jenkinsci.plugins.xunit.threshold.XUnitThresholdDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class XUnitBuilder
extends Builder
implements SimpleBuildStep {
    private TestType[] types;
    private XUnitThreshold[] thresholds;
    private int thresholdMode;
    private ExtraConfiguration extraConfiguration;

    public XUnitBuilder(@CheckForNull TestType[] tools, @CheckForNull XUnitThreshold[] thresholds) {
        this.types = tools != null ? Arrays.copyOf(tools, tools.length) : new TestType[]{};
        this.thresholds = thresholds != null ? Arrays.copyOf(thresholds, thresholds.length) : new XUnitThreshold[]{};
        this.thresholdMode = 1;
    }

    @DataBoundConstructor
    public XUnitBuilder(@CheckForNull TestType[] tools, @CheckForNull XUnitThreshold[] thresholds, int thresholdMode, @CheckForNull String testTimeMargin) {
        this(tools, thresholds);
        this.thresholdMode = thresholdMode;
        long longTestTimeMargin = 3000L;
        if (testTimeMargin != null && testTimeMargin.trim().length() != 0) {
            longTestTimeMargin = Long.parseLong(testTimeMargin);
        }
        this.extraConfiguration = new ExtraConfiguration(longTestTimeMargin);
    }

    public TestType[] getTools() {
        return this.types;
    }

    public String getTestTimeMargin() {
        return String.valueOf(this.getExtraConfiguration().getTestTimeMargin());
    }

    public TestType[] getTypes() {
        return this.types;
    }

    public XUnitThreshold[] getThresholds() {
        return this.thresholds;
    }

    public int getThresholdMode() {
        return this.thresholdMode;
    }

    public ExtraConfiguration getExtraConfiguration() {
        if (this.extraConfiguration == null) {
            this.extraConfiguration = new ExtraConfiguration(3000L);
        }
        return this.extraConfiguration;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        XUnitProcessor xUnitProcessor = new XUnitProcessor(this.getTypes(), this.getThresholds(), this.getThresholdMode(), this.getExtraConfiguration());
        xUnitProcessor.performXUnit(false, build, workspace, listener);
    }

    public boolean performDryRun(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        try {
            XUnitProcessor xUnitProcessor = new XUnitProcessor(this.getTypes(), this.getThresholds(), this.getThresholdMode(), this.getExtraConfiguration());
            xUnitProcessor.performXUnit(true, (Run<?, ?>)build, build.getWorkspace(), (TaskListener)listener);
        }
        catch (Throwable t) {
            listener.getLogger().println("[ERROR] - There is an error: " + t.getCause().getMessage());
        }
        build.setResult(Result.SUCCESS);
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class XUnitDescriptorBuilder
    extends BuildStepDescriptor<Builder> {
        public XUnitDescriptorBuilder() {
            super(XUnitBuilder.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.xUnit_BuilderName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/xunit/help.html";
        }

        public DescriptorExtensionList<TestType, TestTypeDescriptor<?>> getListXUnitTypeDescriptors() {
            return TestTypeDescriptor.all();
        }

        public DescriptorExtensionList<XUnitThreshold, XUnitThresholdDescriptor<?>> getListXUnitThresholdDescriptors() {
            return XUnitThresholdDescriptor.all();
        }

        public XUnitThreshold[] getListXUnitThresholdInstance() {
            return new XUnitThreshold[]{new FailedThreshold(), new SkippedThreshold()};
        }
    }
}

