/*
 * Decompiled with CFR 0.152.
 */
package maps.hudson.plugin.xfpanel;

import hudson.Extension;
import hudson.Functions;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.ViewDescriptor;
import hudson.plugins.claim.ClaimBuildAction;
import hudson.plugins.claim.ClaimTestAction;
import hudson.scm.ChangeLogSet;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.util.FormValidation;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XFPanelView
extends ListView {
    private XFColors colors;
    private Integer numColumns = 2;
    private Integer refresh = 3;
    private Boolean fullHD = false;
    private Integer guiHeight = 205;
    private Integer guiJobFont = 80;
    private Integer guiFailFont = 150;
    private Integer guiInfoFont = 30;
    private Integer guiBuildFont = 30;
    private Integer guiClaimFont = 20;
    private Boolean showDescription = false;
    private Boolean showBrokenBuildCount = false;
    private Boolean showZeroTestCounts = true;
    private Boolean sortDescending = false;
    private Boolean showTimeStamp = true;
    private Boolean enableAutomaticSort = true;
    private Boolean manualSort = false;
    private Boolean showClaimInfo = true;
    private Boolean showWarningIcon = false;
    private Boolean replaceResponsibles = true;
    private Boolean autoResizeEntryHeight = true;
    private Boolean hideSuccessfulBuilds = false;
    private Boolean replaceNumberOfTestCases = true;
    private Boolean showClaimInfoInUnstable = true;
    private transient List<XFPanelEntry> entries;
    private transient Map<Queue.Item, Integer> placeInQueue = new HashMap<Queue.Item, Integer>();
    private Map<String, Integer> priorityPerJob = new HashMap<String, Integer>();
    protected Blame BlameState = Blame.EVERYINVOLVED;
    private Integer maxAmmountOfResponsibles = 1;
    private String responsiblesTopic = "Responsible(s): ";
    private String lastBuildTimePreFix = "last successful: ";
    private String successfulBuildColor = "#7E7EFF";
    private String unstableBuildColor = "#FFC130";
    private String brokenBuildColor = "#FF0000";
    private String otherBuildColor = "#CCCCCC";
    private String buildFontColor = "#FFFFFF";

    @DataBoundConstructor
    public XFPanelView(String name, Integer numColumns) {
        super(name);
        this.numColumns = numColumns != null ? numColumns : 2;
    }

    public XFColors getColors() {
        XFColors obj = new XFColors(this.successfulBuildColor, this.buildFontColor, this.unstableBuildColor, this.buildFontColor, this.brokenBuildColor, this.buildFontColor, this.otherBuildColor, this.buildFontColor);
        if (this.colors == null || !this.colors.equals(obj)) {
            this.colors = obj;
        }
        return this.colors;
    }

    public Integer getGuiHeight() {
        if (this.autoResizeEntryHeight.booleanValue()) {
            Integer entryHeight = this.guiJobFont + this.guiInfoFont;
            if (this.showClaimInfo.booleanValue()) {
                entryHeight = this.BlameState != Blame.NOTATALL ? (this.replaceResponsibles.booleanValue() ? Integer.valueOf(entryHeight + this.guiClaimFont) : Integer.valueOf(entryHeight + (this.guiClaimFont + this.guiInfoFont + this.guiInfoFont / 2))) : Integer.valueOf(entryHeight + this.guiClaimFont);
                if (this.showClaimInfoInUnstable.booleanValue()) {
                    entryHeight = entryHeight + this.guiClaimFont;
                }
            } else if (this.BlameState != Blame.NOTATALL) {
                entryHeight = entryHeight + this.guiInfoFont;
            }
            if (this.showTimeStamp.booleanValue()) {
                entryHeight = entryHeight + (this.guiInfoFont + this.guiInfoFont / 2);
            }
            entryHeight = Math.max(entryHeight, this.guiFailFont);
            entryHeight = Math.max(entryHeight, this.guiJobFont);
            if (this.showZeroTestCounts.booleanValue() && this.showTimeStamp.booleanValue()) {
                entryHeight = Math.max(entryHeight, this.guiJobFont + this.guiInfoFont * 3);
            }
            Integer padding = 15;
            return entryHeight + padding;
        }
        return this.guiHeight;
    }

    public Integer getGuiJobFont() {
        return this.guiJobFont;
    }

    public Integer getGuiFailFont() {
        return this.guiFailFont;
    }

    public Integer getGuiInfoFont() {
        return this.guiInfoFont;
    }

    public Integer getGuiBuildFont() {
        return this.guiBuildFont;
    }

    public Integer getGuiClaimFont() {
        return this.guiClaimFont;
    }

    public Integer getMaxAmmountOfResponsibles() {
        return this.maxAmmountOfResponsibles;
    }

    public Boolean getFullHD() {
        return this.fullHD;
    }

    public Boolean getShowDescription() {
        if (this.showDescription == null) {
            this.showDescription = false;
        }
        return this.showDescription;
    }

    public Boolean getShowBrokenBuildCount() {
        if (this.showBrokenBuildCount == null) {
            this.showBrokenBuildCount = Boolean.FALSE;
        }
        return this.showBrokenBuildCount;
    }

    public Boolean getSortDescending() {
        if (this.sortDescending == null) {
            this.sortDescending = Boolean.FALSE;
        }
        return this.sortDescending;
    }

    public Boolean getShowZeroTestCounts() {
        if (this.showZeroTestCounts == null) {
            this.showZeroTestCounts = Boolean.TRUE;
        }
        return this.showZeroTestCounts;
    }

    public Boolean getShowTimeStamp() {
        return this.showTimeStamp;
    }

    public Boolean getShowClaimInfo() {
        return this.showClaimInfo;
    }

    public Boolean getShowClaimInfoInUnstable() {
        return this.showClaimInfoInUnstable;
    }

    public Boolean getShowWarningIcon() {
        return this.showWarningIcon;
    }

    public Boolean getReplaceResponsibles() {
        return this.replaceResponsibles;
    }

    public Integer getBlameState() {
        return this.BlameState.ordinal();
    }

    public Boolean getAutomaticSortState() {
        return this.enableAutomaticSort;
    }

    public Boolean getManualSortState() {
        return this.manualSort;
    }

    public String getResponsiblesTopic() {
        if (this.responsiblesTopic == null) {
            return "";
        }
        return this.responsiblesTopic;
    }

    public Boolean getHideSuccessfulBuilds() {
        return this.hideSuccessfulBuilds;
    }

    private String validateColor(String current, String defaultColor) {
        if (current != null && current.length() == 7 && current.startsWith("#")) {
            return current.substring(1);
        }
        return defaultColor;
    }

    public String getSuccessfulBuildColor() {
        return this.validateColor(this.successfulBuildColor, "7E7EFF");
    }

    public String getUnstableBuildColor() {
        return this.validateColor(this.unstableBuildColor, "FFC130");
    }

    public String getBrokenBuildColor() {
        return this.validateColor(this.brokenBuildColor, "FF0000");
    }

    public String getOtherBuildColor() {
        return this.validateColor(this.otherBuildColor, "CCCCCC");
    }

    public String getBuildFontColor() {
        return this.validateColor(this.buildFontColor, "FFFFFF");
    }

    public Boolean getPriorityPerJob() {
        return this.priorityPerJob != null;
    }

    public Boolean getIsClaimPluginInstalled() {
        return Hudson.getInstance().getPlugin("claim") != null;
    }

    public Boolean getReplaceNumberOfTestCases() {
        if (this.getIsClaimPluginInstalled().booleanValue()) {
            return this.replaceNumberOfTestCases;
        }
        return false;
    }

    public Boolean getAutoResizeEntryHeight() {
        return this.autoResizeEntryHeight;
    }

    public Collection<XFPanelEntry> sort(Collection<Job<?, ?>> jobs) {
        this.placeInQueue = new HashMap<Queue.Item, Integer>();
        int j = 1;
        for (Queue.Item i : Hudson.getInstance().getQueue().getItems()) {
            this.placeInQueue.put(i, j++);
        }
        if (jobs != null) {
            ArrayList<XFPanelEntry> ents = new ArrayList<XFPanelEntry>();
            if (this.manualSort.booleanValue()) {
                Collection<Job<?, ?>> sortedJobs = this.getPrioritySortedJobs(jobs);
                for (Job<?, ?> job : sortedJobs) {
                    ents.add(new XFPanelEntry(job));
                }
            } else {
                for (Job<?, ?> job : jobs) {
                    ents.add(new XFPanelEntry(job));
                }
            }
            if (this.enableAutomaticSort.booleanValue()) {
                Collections.sort(ents, new selectComparator());
            }
            if (this.getSortDescending().booleanValue()) {
                Collections.reverse(ents);
            }
            this.entries = ents;
            return this.entries;
        }
        return Collections.emptyList();
    }

    public Collection<Job<?, ?>> getPrioritySortedJobs(Collection<Job<?, ?>> jobs) {
        if (jobs != null) {
            ArrayList<Object> sortedJobs = new ArrayList();
            HashMap jobMap = new HashMap();
            int priority = 0;
            int added = 0;
            if (this.priorityPerJob != null) {
                for (Job<?, ?> job : jobs) {
                    if (this.priorityPerJob.containsKey(job.getName())) {
                        priority = this.priorityPerJob.get(job.getName());
                        jobMap.put(priority, job);
                        ++added;
                        continue;
                    }
                    jobMap.put(added, job);
                    ++priority;
                    ++added;
                }
                sortedJobs = new ArrayList(jobMap.values());
            } else {
                for (Job<?, ?> job : jobs) {
                    sortedJobs.add(priority, job);
                    ++priority;
                    ++added;
                }
            }
            return sortedJobs;
        }
        return Collections.emptyList();
    }

    public Integer getRefresh() {
        return this.refresh;
    }

    public Integer getNumColumns() {
        return this.numColumns;
    }

    public String getLastBuildTimePreFix() {
        return this.lastBuildTimePreFix != null ? this.lastBuildTimePreFix : "";
    }

    protected void submit(StaplerRequest req) throws ServletException, Descriptor.FormException, IOException {
        super.submit(req);
        this.numColumns = this.asInteger(req, "numColumns");
        this.refresh = this.asInteger(req, "refresh");
        this.fullHD = Boolean.parseBoolean(req.getParameter("fullHD"));
        this.guiHeight = this.asInteger(req, "guiHeight");
        this.guiJobFont = this.asInteger(req, "guiJobFont");
        this.guiFailFont = this.asInteger(req, "guiFailFont");
        this.guiInfoFont = this.asInteger(req, "guiInfoFont");
        this.guiBuildFont = this.asInteger(req, "guiBuildFont");
        this.showDescription = Boolean.parseBoolean(req.getParameter("showDescription"));
        this.sortDescending = Boolean.parseBoolean(req.getParameter("sortDescending"));
        this.showTimeStamp = Boolean.parseBoolean(req.getParameter("showTimeStamp"));
        this.showZeroTestCounts = Boolean.parseBoolean(req.getParameter("showZeroTestCounts"));
        this.showWarningIcon = Boolean.parseBoolean(req.getParameter("showWarningIcon"));
        this.maxAmmountOfResponsibles = this.asInteger(req, "maxAmmountOfResponsibles");
        this.autoResizeEntryHeight = Boolean.parseBoolean(req.getParameter("autoResizeEntryHeight"));
        this.hideSuccessfulBuilds = Boolean.parseBoolean(req.getParameter("hideSuccessfulBuilds"));
        this.showBrokenBuildCount = Boolean.parseBoolean(req.getParameter("showBrokenBuildCount"));
        if (this.getIsClaimPluginInstalled().booleanValue()) {
            this.guiClaimFont = this.asInteger(req, "guiClaimFont");
            this.showClaimInfo = Boolean.parseBoolean(req.getParameter("showClaimInfo"));
            this.showClaimInfoInUnstable = Boolean.parseBoolean(req.getParameter("showClaimInfoInUnstable"));
            this.replaceResponsibles = Boolean.parseBoolean(req.getParameter("replaceResponsibles"));
            this.replaceNumberOfTestCases = Boolean.parseBoolean(req.getParameter("replaceNumberOfTestCases"));
        }
        this.successfulBuildColor = "#" + req.getParameter("successfulBuildColor");
        this.unstableBuildColor = "#" + req.getParameter("unstableBuildColor");
        this.brokenBuildColor = "#" + req.getParameter("brokenBuildColor");
        this.otherBuildColor = "#" + req.getParameter("otherBuildColor");
        this.buildFontColor = "#" + req.getParameter("buildFontColor");
        if (this.priorityPerJob == null) {
            this.priorityPerJob = new HashMap<String, Integer>();
        }
        int priority = 0;
        this.priorityPerJob.clear();
        for (Item i : Hudson.getInstance().getItems()) {
            String itemName = i.getName();
            if (itemName != null) {
                String paramName = itemName + "_priority";
                try {
                    String priorityStr = req.getParameter(paramName);
                    priority = priorityStr != null ? Integer.parseInt(priorityStr) : 0;
                }
                catch (NumberFormatException e) {
                    ++priority;
                }
                catch (Exception e) {
                    ++priority;
                }
                this.priorityPerJob.put(itemName, priority);
                continue;
            }
            throw new Descriptor.FormException("Couldn't read jobs from the config file. Generate a new config-file: jenkins_job_url/configure", "");
        }
        String SortType = req.getParameter("sort");
        if (SortType != null) {
            this.enableAutomaticSort = false;
            this.manualSort = false;
            if (SortType.equals("sort.automatic")) {
                this.enableAutomaticSort = true;
            } else if (SortType.equals("sort.manual")) {
                this.manualSort = true;
            }
        }
        this.lastBuildTimePreFix = req.getParameter("lastBuildTimePreFix");
        this.responsiblesTopic = req.getParameter("responsiblesTopic");
        String blameType = req.getParameter("responsibles");
        if (blameType == null) {
            System.out.println("WARNING: Show responsibles == null --> Show responsibles disabled");
            this.BlameState = Blame.NOTATALL;
        } else if (blameType.equals("blame.notAtAll")) {
            this.BlameState = Blame.NOTATALL;
        } else if (blameType.equals("blame.onlyFirstFailedBuild")) {
            this.BlameState = Blame.ONLYFIRSTFAILEDBUILD;
        } else if (blameType.equals("blame.onlyLastFailedBuild")) {
            this.BlameState = Blame.ONLYLASTFAILEDBUILD;
        } else if (blameType.equals("blame.everyInvolved")) {
            this.BlameState = Blame.EVERYINVOLVED;
        }
    }

    private Integer asInteger(StaplerRequest request, String parameterName) throws Descriptor.FormException {
        try {
            return Integer.parseInt(request.getParameter(parameterName));
        }
        catch (NumberFormatException e) {
            throw new Descriptor.FormException(parameterName + " must be a positive integer", parameterName);
        }
    }

    public static final class XFColors {
        private String okBG;
        private String okFG;
        private String failedBG;
        private String failedFG;
        private String brokenBG;
        private String brokenFG;
        private String otherBG;
        private String otherFG;
        public static final XFColors DEFAULT = new XFColors("#7E7EFF", "#FFFFFF", "#FFC130", "#FFFFFF", "#FF0000", "#FFFFFF", "#CCCCCC", "#FFFFFF");

        public XFColors(String okBG, String okFG, String failedBG, String failedFG, String brokenBG, String brokenFG, String otherBG, String otherFG) {
            this.okBG = okBG;
            this.okFG = okFG;
            this.failedBG = failedBG;
            this.failedFG = failedFG;
            this.brokenBG = brokenBG;
            this.brokenFG = brokenFG;
            this.otherBG = otherBG;
            this.otherFG = otherFG;
        }

        public String getOkBG() {
            return this.okBG;
        }

        public String getOkFG() {
            return this.okFG;
        }

        public String getFailedBG() {
            return this.failedBG;
        }

        public String getFailedFG() {
            return this.failedFG;
        }

        public String getBrokenBG() {
            return this.brokenBG;
        }

        public String getBrokenFG() {
            return this.brokenFG;
        }

        public String getOtherBG() {
            return this.otherBG;
        }

        public String getOtherFG() {
            return this.otherFG;
        }
    }

    @Extension
    public static final class XFPanelViewDescriptor
    extends ViewDescriptor {
        public static final String REFRESH_MSG = "Refresh time must be a positive integer.";
        public static final String MSG = "Number of columns currently supported is 1 or 2.";

        public String getDisplayName() {
            return "eXtreme Feedback Panel";
        }

        public FormValidation doCheckNumColumns(@QueryParameter String value) {
            try {
                int i = Integer.parseInt(value);
                if (i < 1 || i > 2) {
                    return FormValidation.error((String)MSG);
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)MSG);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRefresh(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        public FormValidation doCheckGuiHeight(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        public FormValidation doCheckGuiJobFont(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        public FormValidation doCheckGuiFailFont(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        public FormValidation doCheckGuiInfoFont(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        public FormValidation doCheckGuiBuildFont(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        private FormValidation isPositiveInteger(String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class XFPanelEntry {
        private Job<?, ?> job;
        private String backgroundColor;
        private String color;
        private String colorFade = "";
        private Boolean broken;
        private Boolean building = false;
        private Boolean queued = false;
        private Integer queueNumber;
        private String completionTimestampString = "";
        private Calendar completionTimestamp;

        public XFPanelEntry(Job<?, ?> job) {
            this.job = job;
            this.findStatus();
            this.setTimes();
        }

        public Job<?, ?> getJob() {
            return this.job;
        }

        public String getName() {
            String label = this.job.getDisplayName().toUpperCase();
            if (XFPanelView.this.getShowDescription().booleanValue() && !this.job.getDescription().isEmpty()) {
                label = label + ": " + this.job.getDescription();
            }
            return label;
        }

        public Boolean getQueued() {
            return this.job.isInQueue();
        }

        public Integer getQueueNumber() {
            return XFPanelView.this.placeInQueue == null ? null : (Integer)XFPanelView.this.placeInQueue.get(this.job.getQueueItem());
        }

        private void setTimes() {
            AbstractBuild lastBuild = (AbstractBuild)this.job.getLastCompletedBuild();
            if (lastBuild != null) {
                this.completionTimestamp = lastBuild.getTimestamp();
                this.completionTimestampString = lastBuild.getTimestampString();
            }
        }

        public void setCompletionTimestamp(Calendar completionTimestamp) {
            this.completionTimestamp = completionTimestamp;
        }

        public Calendar getCompletionTimestamp() {
            return this.completionTimestamp;
        }

        public void setCompletionTimestampString(String completionTimestampString) {
            this.completionTimestampString = completionTimestampString;
        }

        public String getCompletionTimestampString() {
            return this.completionTimestampString;
        }

        public String getBackgroundColor() {
            return this.backgroundColor;
        }

        public String getColor() {
            return this.color;
        }

        public String getColorFade() {
            return this.colorFade;
        }

        public Boolean getBroken() {
            return this.broken;
        }

        public Boolean getShowResponsibles() {
            if (XFPanelView.this.BlameState == Blame.NOTATALL) {
                return false;
            }
            return true;
        }

        public Boolean getBuilding() {
            return this.building;
        }

        public String getUrl() {
            return this.job.getUrl() + "lastBuild";
        }

        public List<Run<?, ?>> getBuildsInProgress() {
            ArrayList runs = new ArrayList();
            Run run = this.job.getLastBuild();
            if (run.isBuilding()) {
                runs.add(run);
            }
            for (Run prev = run.getPreviousBuildInProgress(); prev != null; prev = prev.getPreviousBuildInProgress()) {
                runs.add(prev);
            }
            return runs;
        }

        public int getTestCount() {
            Run run = this.job.getLastSuccessfulBuild();
            if (run != null) {
                AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
                return tests != null ? tests.getTotalCount() : 0;
            }
            return 0;
        }

        public int getFailCount() {
            Run run = this.job.getLastSuccessfulBuild();
            if (run != null) {
                AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
                return tests != null ? tests.getFailCount() : 0;
            }
            return 0;
        }

        public int getSuccessCount() {
            return this.getTestCount() - this.getFailCount();
        }

        public int getLastCompletedBuildNumber() {
            return this.job.getLastCompletedBuild().getNumber();
        }

        public String getLastCompletedBuildTimestampString() {
            return this.job.getLastCompletedBuild().getTimestampString();
        }

        public int getNumberOfFailedBuilds() {
            Run lastSuccess = this.job.getLastSuccessfulBuild();
            Run lastCompiled = this.job.getLastCompletedBuild();
            if (lastSuccess == null || lastCompiled == null) {
                return 0;
            }
            int numberOfFailedBuilds = lastCompiled.getNumber() - lastSuccess.getNumber();
            return numberOfFailedBuilds;
        }

        public String getDiff() {
            Run<?, ?> previous;
            Run run = this.job.getLastSuccessfulBuild();
            if (run != null && (previous = this.getLastSuccessfulFrom(run)) != null) {
                AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
                AbstractTestResultAction prevTests = (AbstractTestResultAction)previous.getAction(AbstractTestResultAction.class);
                if (tests != null && prevTests != null) {
                    int currentSuccess = tests.getTotalCount() - tests.getFailCount();
                    int prevSuccess = prevTests.getTotalCount() - prevTests.getFailCount();
                    return Functions.getDiffString((int)(currentSuccess - prevSuccess));
                }
            }
            return "";
        }

        private Run<?, ?> getLastSuccessfulFrom(Run<?, ?> run) {
            Run r;
            for (r = run.getPreviousBuild(); r != null && (r.isBuilding() || r.getResult() == null || r.getResult().isWorseThan(Result.UNSTABLE)); r = r.getPreviousBuild()) {
            }
            return r;
        }

        public HashSet<User> getCulpritFromBuild(AbstractBuild<?, ?> build) {
            HashSet<User> r = new HashSet<User>();
            for (ChangeLogSet.Entry e : build.getChangeSet()) {
                r.add(e.getAuthor());
            }
            return r;
        }

        public String convertCulpritsToString(HashSet<User> input) {
            String output = "";
            Iterator<User> it = input.iterator();
            int i = 0;
            while (it.hasNext()) {
                if (i < XFPanelView.this.getMaxAmmountOfResponsibles()) {
                    output = output + it.next().getFullName() + (it.hasNext() ? ", " : "");
                } else {
                    it.next();
                }
                ++i;
            }
            if (i > XFPanelView.this.getMaxAmmountOfResponsibles()) {
                output = output + "... <" + (i - XFPanelView.this.getMaxAmmountOfResponsibles()) + " more>";
            }
            if (!output.isEmpty()) {
                return output;
            }
            return " - ";
        }

        public String getCulprits() {
            Run run;
            if (XFPanelView.this.BlameState == Blame.ONLYFIRSTFAILEDBUILD) {
                Run run2 = this.job.getLastStableBuild();
                run2 = run2 == null ? this.job.getFirstBuild() : run2.getNextBuild();
                if (run2 instanceof AbstractBuild) {
                    AbstractBuild firstFailedBuild = (AbstractBuild)run2;
                    return this.convertCulpritsToString(this.getCulpritFromBuild(firstFailedBuild));
                }
            } else if (XFPanelView.this.BlameState == Blame.ONLYLASTFAILEDBUILD) {
                Run run3 = this.job.getLastFailedBuild();
                if (run3 instanceof AbstractBuild) {
                    AbstractBuild lastFailedBuild = (AbstractBuild)run3;
                    return this.convertCulpritsToString(this.getCulpritFromBuild(lastFailedBuild));
                }
            } else if (XFPanelView.this.BlameState == Blame.EVERYINVOLVED && (run = this.job.getLastBuild()) instanceof AbstractBuild) {
                AbstractBuild build = (AbstractBuild)run;
                HashSet<User> BlameList = new HashSet<User>(build.getCulprits());
                return this.convertCulpritsToString(BlameList);
            }
            return " -";
        }

        private ClaimBuildAction getClaimAction() {
            ClaimBuildAction claimAction = null;
            if (Hudson.getInstance().getPlugin("claim") != null) {
                List claimActionList;
                Run lastBuild = this.job.getLastBuild();
                if (lastBuild != null && lastBuild.isBuilding()) {
                    lastBuild = lastBuild.getPreviousBuild();
                }
                if (lastBuild != null && (claimActionList = lastBuild.getActions(ClaimBuildAction.class)).size() == 1) {
                    claimAction = (ClaimBuildAction)claimActionList.get(0);
                }
            }
            return claimAction;
        }

        public boolean isClaimed() {
            boolean result = false;
            if (XFPanelView.this.getIsClaimPluginInstalled().booleanValue()) {
                ClaimBuildAction cba = this.getClaimAction();
                if (cba != null) {
                    result = cba.isClaimed();
                }
                if (!result) {
                    int claimedTests = this.getNumClaimedTests();
                    int totalTests = this.getFailCount();
                    if (totalTests > 0 && claimedTests == totalTests) {
                        result = true;
                    }
                }
            }
            return result;
        }

        public String getClaimInfo() {
            String name;
            ClaimBuildAction claimAction = this.getClaimAction();
            if (claimAction != null && claimAction.isClaimed() && (name = claimAction.getClaimedByName()) != null) {
                return name;
            }
            return "";
        }

        public TestResult getClaimedTestCases() {
            if (Hudson.getInstance().getPlugin("claim") != null) {
                Run lastBuild = this.job.getLastBuild();
                if (lastBuild == null) {
                    return null;
                }
                if (lastBuild.isBuilding() && (lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) == null) {
                    return null;
                }
                List claimTestActionList = lastBuild.getActions();
                List results = lastBuild.getActions(TestResultAction.class);
                if (results == null || claimTestActionList == null || results.size() == 0) {
                    return null;
                }
                return ((TestResultAction)results.get(0)).getResult();
            }
            return null;
        }

        public String getClaimInfoByTestCases() {
            TestResult testResult = this.getClaimedTestCases();
            if (testResult == null) {
                return "";
            }
            String claimers = "";
            HashSet<String> claimerNames = new HashSet<String>();
            for (CaseResult result : testResult.getFailedTests()) {
                String claimer;
                ClaimTestAction claimTestAction = (ClaimTestAction)result.getTestAction(ClaimTestAction.class);
                if (claimTestAction == null || !claimTestAction.isClaimed() || (claimer = claimTestAction.getClaimedBy()) == null || claimer == "" || claimerNames.contains(claimer)) continue;
                claimerNames.add(claimer);
                if (claimers != "") {
                    claimers = claimers + ", ";
                }
                claimers = claimers + claimer;
            }
            if (claimers == null || claimers == "") {
                String buildClaimer = "";
                buildClaimer = this.getClaimInfo();
                if (buildClaimer == null || buildClaimer == "") {
                    return "";
                }
                return "Build claimed by: " + buildClaimer;
            }
            return "Claimed by: " + claimers;
        }

        public int getNumClaimedTests() {
            TestResult testResult = this.getClaimedTestCases();
            if (testResult != null) {
                int numClaimedTests = 0;
                for (CaseResult result : testResult.getFailedTests()) {
                    ClaimTestAction claimTestAction = (ClaimTestAction)result.getTestAction(ClaimTestAction.class);
                    if (claimTestAction == null || !claimTestAction.isClaimed()) continue;
                    ++numClaimedTests;
                }
                return numClaimedTests;
            }
            return -1;
        }

        public String getNumberOfTests() {
            int claimedTests;
            int failedTests = this.getFailCount();
            if (failedTests == 0 && !XFPanelView.this.getShowZeroTestCounts().booleanValue()) {
                return "";
            }
            if (XFPanelView.this.getReplaceNumberOfTestCases().booleanValue() && (claimedTests = this.getNumClaimedTests()) >= 0) {
                return Integer.toString(failedTests - claimedTests);
            }
            return Integer.toString(failedTests);
        }

        public String getDiffColor() {
            String diff = this.getDiff().trim();
            if (diff.length() > 0) {
                if (diff.startsWith("-")) {
                    return "#FF0000";
                }
                return "#00FF00";
            }
            return "#" + XFPanelView.this.getBuildFontColor();
        }

        public String getSuccessPercentage() {
            if (this.getTestCount() > 0) {
                Double perc = (double)this.getSuccessCount() / ((double)this.getTestCount() * 1.0);
                return NumberFormat.getPercentInstance().format(perc);
            }
            return "";
        }

        public String getBuildStatus(AbstractBuild build) {
            if (build == null) {
                return "UNBUILT";
            }
            if (build.isBuilding()) {
                build = (AbstractBuild)build.getPreviousBuild();
                return this.getBuildStatus(build);
            }
            Result result = build.getResult();
            if (result != null) {
                return result.toString();
            }
            return "UNKNOWN";
        }

        public boolean isBuildSuccessful() {
            AbstractBuild build = (AbstractBuild)this.job.getLastBuild();
            if (build != null) {
                String buildStatus = this.getBuildStatus(build);
                return buildStatus.equals("SUCCESS");
            }
            return false;
        }

        public boolean isBuildUnstable() {
            AbstractBuild build = (AbstractBuild)this.job.getLastBuild();
            if (build != null) {
                String buildStatus = this.getBuildStatus(build);
                return buildStatus.equals("UNSTABLE");
            }
            return false;
        }

        private void findStatus() {
            switch (this.job.getIconColor()) {
                case BLUE_ANIME: {
                    this.building = true;
                }
                case BLUE: {
                    this.backgroundColor = XFPanelView.this.getColors().getOkBG();
                    this.color = XFPanelView.this.colors.getOkFG();
                    this.colorFade = "build-fade-ok.png";
                    this.broken = false;
                    break;
                }
                case YELLOW_ANIME: {
                    this.building = true;
                }
                case YELLOW: {
                    this.backgroundColor = XFPanelView.this.getColors().getFailedBG();
                    this.color = XFPanelView.this.colors.getFailedFG();
                    this.colorFade = "build-fade-fail.png";
                    this.broken = false;
                    break;
                }
                case RED_ANIME: {
                    this.building = true;
                }
                case RED: {
                    this.backgroundColor = XFPanelView.this.getColors().getBrokenBG();
                    this.color = XFPanelView.this.colors.getBrokenFG();
                    this.colorFade = "build-fade-broken.png";
                    this.broken = true;
                    break;
                }
                case GREY_ANIME: 
                case DISABLED_ANIME: 
                case ABORTED_ANIME: {
                    this.building = true;
                }
                default: {
                    this.backgroundColor = XFPanelView.this.getColors().getOtherBG();
                    this.color = XFPanelView.this.colors.getOtherFG();
                    this.colorFade = "build-fade-other.png";
                    this.broken = true;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class selectComparator
    implements Comparator<XFPanelEntry> {
        selectComparator() {
        }

        private int getPriority(AbstractBuild build) {
            if (build == null) {
                return 1;
            }
            if (build.isBuilding()) {
                build = (AbstractBuild)build.getPreviousBuild();
                return this.getPriority(build);
            }
            Result result = build.getResult();
            if (result != null) {
                Result[] allResults = new Result[]{Result.SUCCESS, Result.ABORTED, Result.NOT_BUILT, Result.UNSTABLE, Result.FAILURE};
                int[] resultValues = new int[]{0, 1, 1, 2, 3};
                for (int i = 0; i < allResults.length; ++i) {
                    if (result != allResults[i]) continue;
                    return resultValues[i];
                }
            }
            return 1;
        }

        @Override
        public int compare(XFPanelEntry a, XFPanelEntry b) {
            AbstractBuild buildA = (AbstractBuild)a.job.getLastBuild();
            AbstractBuild buildB = (AbstractBuild)b.job.getLastBuild();
            int result = this.getPriority(buildB) - this.getPriority(buildA);
            if (result == 0) {
                if (buildA == null || buildB == null) {
                    return buildA == null ? 1 : 0;
                }
                if (buildA.isBuilding() || buildB.isBuilding()) {
                    return buildA.isBuilding() ? 0 : 1;
                }
                return b.completionTimestamp.compareTo(a.completionTimestamp);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Blame {
        NOTATALL,
        ONLYLASTFAILEDBUILD,
        ONLYFIRSTFAILEDBUILD,
        EVERYINVOLVED;

    }
}

