/*
 * Decompiled with CFR 0.152.
 */
package au.com.rayh;

import au.com.rayh.KeychainPasswordAndPath;
import au.com.rayh.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.kohsuke.stapler.DataBoundConstructor;

public class KeychainPasswordAndPathBinding
extends MultiBinding<KeychainPasswordAndPath> {
    public static final String DEFAULT_KEYCHAIN_PATH_VARIABLE_NAME = "KEYCHAIN_PATH";
    private static final String DEFAULT_PASSWORD_VARIABLE_NAME = "PASSWORD";
    private static final String DEFAULT_IN_SEARCH_PATH_VARIABLE_NAME = "IN_SEARCH_PATH";
    @NonNull
    private final String keychainPathVariable;
    @NonNull
    private final String passwordVariable;
    @NonNull
    private final String inSearchPathVariable;

    @DataBoundConstructor
    public KeychainPasswordAndPathBinding(@Nullable String keychainPathVariable, @Nullable String passwordVariable, @Nullable String inSearchPathVariable, String credentialsId) {
        super(credentialsId);
        this.keychainPathVariable = StringUtils.defaultIfBlank((String)keychainPathVariable, (String)DEFAULT_KEYCHAIN_PATH_VARIABLE_NAME);
        this.passwordVariable = StringUtils.defaultIfBlank((String)passwordVariable, (String)DEFAULT_PASSWORD_VARIABLE_NAME);
        this.inSearchPathVariable = StringUtils.defaultIfBlank((String)inSearchPathVariable, (String)DEFAULT_IN_SEARCH_PATH_VARIABLE_NAME);
    }

    @NonNull
    public String getKeychainPathVariable() {
        return this.keychainPathVariable;
    }

    @NonNull
    public String getPasswordVariable() {
        return this.passwordVariable;
    }

    @NonNull
    public String getInSearchPathVariable() {
        return this.inSearchPathVariable;
    }

    protected Class<KeychainPasswordAndPath> type() {
        return KeychainPasswordAndPath.class;
    }

    public MultiBinding.MultiEnvironment bind(@Nonnull Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        KeychainPasswordAndPath credential = (KeychainPasswordAndPath)this.getCredentials(build);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(this.keychainPathVariable, credential.getKeychainPath());
        m.put(this.passwordVariable, credential.getPassword().getPlainText());
        m.put(this.inSearchPathVariable, credential.getInSearchPath());
        return new MultiBinding.MultiEnvironment(m);
    }

    public Set<String> variables() {
        return new HashSet<String>(Arrays.asList(this.keychainPathVariable, this.passwordVariable, this.inSearchPathVariable));
    }

    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<KeychainPasswordAndPath> {
        protected Class<KeychainPasswordAndPath> type() {
            return KeychainPasswordAndPath.class;
        }

        public String getDisplayName() {
            return Messages.KeychainPasswordAndPath_DisplayName();
        }
    }
}

