/*
 * Decompiled with CFR 0.152.
 */
package au.com.rayh;

import au.com.rayh.XCodeBuildOutputParser;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;

public class JenkinsXCodeBuildOutputParser
extends XCodeBuildOutputParser {
    protected TaskListener buildListener;
    private FilePath testReportsDir;
    private OutputStream logFileOutputStream;
    private boolean ignoreTestResults;

    public JenkinsXCodeBuildOutputParser(FilePath workspace, TaskListener buildListener) throws IOException, InterruptedException {
        this.buildListener = buildListener;
        this.captureOutputStream = new LineBasedFilterOutputStream();
        this.consoleLog = true;
        this.logFileOutputStream = null;
        this.ignoreTestResults = false;
        this.testReportsDir = workspace.child("test-reports");
        this.testReportsDir.mkdirs();
    }

    public void setConsoleLog(boolean consoleLog) {
        this.consoleLog = consoleLog;
    }

    public void setIgnoreTestResults(boolean ignoreTestResults) {
        this.ignoreTestResults = ignoreTestResults;
    }

    public void setLogfilePath(FilePath buildDirectory, String logfileOutputDirectory) throws IOException, InterruptedException {
        if (!StringUtils.isEmpty((String)logfileOutputDirectory)) {
            FilePath logFilePath = buildDirectory.child(logfileOutputDirectory);
            if (logFilePath.exists()) {
                logFilePath.deleteRecursive();
            }
            if (!logFilePath.exists()) {
                logFilePath.mkdirs();
            }
            this.logFileOutputStream = new BufferedOutputStream(logFilePath.child("xcodebuild.log").write(), 524288);
        }
    }

    public void closeLogfile() throws IOException {
        if (this.logFileOutputStream != null) {
            this.logFileOutputStream.flush();
            this.logFileOutputStream.close();
            this.logFileOutputStream = null;
        }
    }

    @Override
    protected OutputStream outputForSuite() throws IOException, InterruptedException {
        return this.testReportsDir.child("TEST-" + this.currentTestSuite.getName() + ".xml").write();
    }

    public class LineBasedFilterOutputStream
    extends FilterOutputStream {
        StringBuilder buffer;

        public LineBasedFilterOutputStream() {
            super(JenkinsXCodeBuildOutputParser.this.buildListener.getLogger());
            this.buffer = new StringBuilder();
        }

        @Override
        public void write(int b) throws IOException {
            if (!JenkinsXCodeBuildOutputParser.this.ignoreTestResults) {
                if ((char)b == '\n') {
                    try {
                        JenkinsXCodeBuildOutputParser.this.handleLine(this.buffer.toString());
                        this.buffer = new StringBuilder();
                    }
                    catch (Exception e) {
                        JenkinsXCodeBuildOutputParser.this.buildListener.fatalError(e.getMessage(), new Object[]{e});
                        throw new IOException(e);
                    }
                } else {
                    this.buffer.append((char)b);
                }
            }
            if (JenkinsXCodeBuildOutputParser.this.consoleLog) {
                super.write(b);
            }
            if (JenkinsXCodeBuildOutputParser.this.logFileOutputStream != null) {
                JenkinsXCodeBuildOutputParser.this.logFileOutputStream.write(b);
            }
        }

        @Override
        public void close() throws IOException {
            if (JenkinsXCodeBuildOutputParser.this.logFileOutputStream != null) {
                JenkinsXCodeBuildOutputParser.this.logFileOutputStream.flush();
                JenkinsXCodeBuildOutputParser.this.logFileOutputStream.close();
                JenkinsXCodeBuildOutputParser.this.logFileOutputStream = null;
            }
            super.close();
        }
    }
}

