/*
 * Decompiled with CFR 0.152.
 */
package au.com.rayh;

import au.com.rayh.Keychain;
import au.com.rayh.Messages;
import au.com.rayh.Team;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public final class GlobalConfigurationImpl
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(GlobalConfigurationImpl.class.getName());
    @CheckForNull
    private String xcodebuildPath = "/usr/bin/xcodebuild";
    @CheckForNull
    private String xcrunPath = "/usr/bin/xcrun";
    @CheckForNull
    private String agvtoolPath = "/usr/bin/agvtool";
    @Deprecated
    @CheckForNull
    private String defaultKeychain = "";
    @Deprecated
    @CheckForNull
    private ArrayList<Keychain> keychains = new ArrayList();
    @Deprecated
    @CheckForNull
    private ArrayList<Team> teams = new ArrayList();

    @DataBoundSetter
    public void setXcodebuildPath(String xcodebuildPath) {
        this.xcodebuildPath = xcodebuildPath;
    }

    @CheckForNull
    public String getXcodebuildPath() {
        return this.xcodebuildPath;
    }

    @DataBoundSetter
    public void setXcrunPath(String xcrunPath) {
        this.xcrunPath = xcrunPath;
    }

    @CheckForNull
    public String getXcrunPath() {
        return this.xcrunPath;
    }

    @DataBoundSetter
    public void setAgvtoolPath(String agvtoolPath) {
        this.agvtoolPath = agvtoolPath;
    }

    @CheckForNull
    public String getAgvtoolPath() {
        return this.agvtoolPath;
    }

    @Deprecated
    @DataBoundSetter
    public void setDefaultKeychain(String defaultKeychain) {
        this.defaultKeychain = defaultKeychain;
    }

    @Deprecated
    @CheckForNull
    public String getDefaultKeychain() {
        return this.defaultKeychain;
    }

    @Deprecated
    @DataBoundSetter
    public void setKeychains(ArrayList<Keychain> keychains) {
        this.keychains = keychains;
    }

    @Deprecated
    public ArrayList<Keychain> getKeychains() {
        return this.keychains == null ? this.keychains : new ArrayList<Keychain>();
    }

    @Deprecated
    @DataBoundSetter
    public void setTeams(ArrayList<Team> teams) {
        this.teams = teams;
    }

    @Deprecated
    public ArrayList<Team> getTeams() {
        return this.teams;
    }

    @DataBoundConstructor
    public GlobalConfigurationImpl() {
        this.load();
        LOGGER.fine("[Xcode] Default constructor: " + this.getKeychains().size());
    }

    @Deprecated
    public GlobalConfigurationImpl(String xcodebuildPath, String xcrunPath, String agvtoolPath, String defaultKeychain, ArrayList<Keychain> keychains, ArrayList<Team> teams) {
        this();
        this.setXcodebuildPath(xcodebuildPath);
        this.setXcrunPath(xcrunPath);
        this.setAgvtoolPath(agvtoolPath);
        this.setDefaultKeychain(defaultKeychain);
        this.setKeychains(keychains);
        this.setTeams(teams);
        LOGGER.fine("[Xcode] DataBoundConstructor: keychains.size " + keychains.size());
        if (teams != null) {
            LOGGER.fine("[Xcode] DataBoundConstructor: teams.size " + teams.size());
        }
    }

    @Deprecated
    public GlobalConfigurationImpl(String xcodebuildPath, String xcrunPath, String agvtoolPath, String defaultKeychain, ArrayList<Keychain> keychains) {
        this(xcodebuildPath, xcrunPath, agvtoolPath, defaultKeychain, keychains, null);
    }

    public FormValidation doCheckXcodebuildPath(@QueryParameter String value) throws IOException, ServletException {
        if (StringUtils.isEmpty((String)value)) {
            return FormValidation.error((String)Messages.XCodeBuilder_xcodebuildPathNotSet());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckAgvtoolPath(@QueryParameter String value) throws IOException, ServletException {
        if (StringUtils.isEmpty((String)value)) {
            return FormValidation.error((String)Messages.XCodeBuilder_agvtoolPathNotSet());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckXcrunPath(@QueryParameter String value) throws IOException, ServletException {
        if (StringUtils.isEmpty((String)value)) {
            return FormValidation.error((String)Messages.XCodeBuilder_xcrunPathNotSet());
        }
        return FormValidation.ok();
    }

    public AutoCompletionCandidates doAutoCompleteDefaultKeychain(@QueryParameter String value) {
        AutoCompletionCandidates c = new AutoCompletionCandidates();
        for (Keychain keychain : this.getKeychains()) {
            if (!keychain.getKeychainName().toLowerCase().startsWith(value.toLowerCase())) continue;
            c.add(keychain.getKeychainName());
        }
        return c;
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return true;
    }

    public String getDisplayName() {
        return Messages.XCodeBuilder_xcode();
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        req.bindJSON((Object)this, formData);
        this.setKeychains(new ArrayList<Keychain>(req.bindParametersToList(Keychain.class, "keychain.")));
        this.setTeams(new ArrayList<Team>(req.bindParametersToList(Team.class, "team.")));
        this.save();
        return super.configure(req, formData);
    }
}

