/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.wildfly;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TopLevelItem;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jboss.as.cli.scriptsupport.CLI;
import org.jboss.dmr.ModelNode;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class WildflyBuilder
extends Builder {
    private final String war;
    private final String host;
    private final String port;
    private final String username;
    private final String password;
    private final String server;

    @DataBoundConstructor
    public WildflyBuilder(String war, String host, String port, String username, String password, String server) {
        this.war = StringUtils.trim((String)war);
        this.host = StringUtils.trim((String)host);
        this.port = StringUtils.trim((String)port);
        this.username = StringUtils.trim((String)username);
        this.password = StringUtils.trim((String)password);
        this.server = StringUtils.trim((String)server);
    }

    public String getWar() {
        return this.war;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getServer() {
        return this.server;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        FilePath localFP = null;
        try {
            String response;
            CLI.Result result;
            String warPath;
            int portAsInt = Integer.parseInt(this.port);
            FilePath fp = new FilePath(build.getWorkspace(), this.war);
            String remotePath = fp.getRemote();
            if (!fp.exists()) {
                listener.fatalError("The '" + this.war + "' file does not exist in workspace.");
                return false;
            }
            if (fp.isRemote()) {
                String localPath = Jenkins.getInstance().getWorkspaceFor((TopLevelItem)build.getProject().getRootProject()).getRemote();
                localPath = localPath.concat("/" + this.war);
                localFP = new FilePath(new File(localPath));
                fp.act((FilePath.FileCallable)new GrabWARFile(localFP));
                warPath = localPath;
            } else {
                warPath = remotePath;
            }
            CLI cli = CLI.newInstance();
            if (this.username.length() > 0) {
                char[] passwordAsCharArray = this.password.toCharArray();
                cli.connect(this.host, portAsInt, this.username, passwordAsCharArray);
            } else {
                cli.connect(this.host, portAsInt, null, null);
            }
            listener.getLogger().println("Connected to WildFly at " + this.host + ":" + this.port);
            int idx = this.war.lastIndexOf("/");
            String warFilename = idx > 0 ? this.war.substring(idx + 1, this.war.length()) : this.war;
            if (this.applicationExists(cli, warFilename, this.server)) {
                listener.getLogger().println("Application " + warFilename + " exists, undeploying...");
                result = this.server.length() > 0 ? cli.cmd("undeploy " + warFilename + " --server-groups=" + this.server) : cli.cmd("undeploy " + warFilename);
                response = this.getWildFlyResponse(result);
                if (response.indexOf("{\"outcome\" => \"failed\"") >= 0) {
                    listener.fatalError(response);
                    return false;
                }
                listener.getLogger().println(response);
            }
            listener.getLogger().println("Deploying " + warFilename + " ...");
            result = this.server.length() > 0 ? cli.cmd("deploy " + warPath + " --server-groups=" + this.server) : cli.cmd("deploy " + warPath);
            response = this.getWildFlyResponse(result);
            if (response.indexOf("{\"outcome\" => \"failed\"") >= 0) {
                listener.fatalError(response);
                return false;
            }
            listener.getLogger().println(response);
            cli.disconnect();
            if (localFP != null) {
                localFP.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            listener.fatalError(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean applicationExists(CLI cli, String war, String server) {
        CLI.Result result = server.length() > 0 ? cli.cmd("deployment-info --server-group=" + server) : cli.cmd("deployment-info");
        String response = this.getWildFlyResponse(result);
        return response.indexOf(war) >= 0;
    }

    private String getWildFlyResponse(CLI.Result result) {
        ModelNode modelNode = result.getResponse();
        String response = modelNode.asString();
        return response;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckWar(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify a WAR or EAR filename.");
            }
            if (!value.toLowerCase().contains(".war".toLowerCase()) && !value.toLowerCase().contains(".ear".toLowerCase())) {
                return FormValidation.error((String)"Please specify a valid WAR or EAR filename.");
            }
            if (value.length() < 7) {
                return FormValidation.warning((String)"Is that a valid WAR or EAR filename?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckHost(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify a valid hostname.");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Is that a valid hostname?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPort(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0 || value.length() < 4 || value.length() > 5 || !value.matches("[0-9]+")) {
                return FormValidation.error((String)"Please specify a valid port number.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPassword(@QueryParameter String value, @QueryParameter String username) throws IOException, ServletException {
            if (value.length() != 0 && username.length() == 0) {
                return FormValidation.error((String)"Both a user name and a password must be specified.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUsername(@QueryParameter String value, @QueryParameter String password) throws IOException, ServletException {
            if (value.length() != 0 && password.length() == 0) {
                return FormValidation.error((String)"Both a user name and a password must be specified.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckServer(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() > 0 && value.length() < 5) {
                return FormValidation.warning((String)"Is that a valid server group or standalone server name?");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Deploy WAR/EAR to WildFly";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }

    private static final class GrabWARFile
    implements FilePath.FileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final FilePath fp;

        public GrabWARFile(FilePath fp) {
            this.fp = fp;
        }

        public Void invoke(File f, VirtualChannel channel) {
            try {
                FilePath remoteFilePath = new FilePath(f);
                this.fp.copyFrom(remoteFilePath);
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }
}

