/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.weibo.client;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.jenkinsci.plugins.weibo.WeiboAccount;
import weibo4j.Oauth;
import weibo4j.Timeline;
import weibo4j.http.AccessToken;
import weibo4j.model.WeiboException;
import weibo4j.util.WeiboConfig;

public class WeiboClient {
    public static AccessToken getToken(String username, String password) throws HttpException, IOException {
        String retUrl;
        int begin;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        System.out.println(contextClassLoader.getResource(""));
        String clientId = WeiboConfig.getValue("client_ID");
        String redirectURI = WeiboConfig.getValue("redirect_URI");
        String url = WeiboConfig.getValue("authorizeURL");
        System.out.println("clientId:" + clientId);
        PostMethod postMethod = new PostMethod(url);
        postMethod.addParameter("client_id", clientId);
        postMethod.addParameter("redirect_uri", redirectURI);
        postMethod.addParameter("userId", username);
        postMethod.addParameter("passwd", password);
        postMethod.addParameter("isLoginSina", "0");
        postMethod.addParameter("action", "submit");
        postMethod.addParameter("response_type", "code");
        HttpMethodParams param = postMethod.getParams();
        param.setContentCharset("UTF-8");
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add(new Header("Referer", "https://api.weibo.com/oauth2/authorize?client_id=" + clientId + "&redirect_uri=" + redirectURI + "&from=sina&response_type=code"));
        headers.add(new Header("Host", "api.weibo.com"));
        headers.add(new Header("User-Agent", "Mozilla/5.0 (Windows NT 6.1; rv:11.0) Gecko/20100101 Firefox/11.0"));
        HttpClient client = new HttpClient();
        client.getHostConfiguration().getParams().setParameter("http.default-headers", headers);
        client.executeMethod((HttpMethod)postMethod);
        int status = postMethod.getStatusCode();
        System.out.println(status);
        if (status != 302) {
            return null;
        }
        Header location = postMethod.getResponseHeader("Location");
        if (location != null && (begin = (retUrl = location.getValue()).indexOf("code=")) != -1) {
            String code;
            int end = retUrl.indexOf("&", begin);
            if (end == -1) {
                end = retUrl.length();
            }
            if ((code = retUrl.substring(begin + 5, end)) != null) {
                Oauth oauth = new Oauth();
                try {
                    AccessToken token = oauth.getAccessTokenByCode(code);
                    return token;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static boolean sinaSendWeibo(String token, String content) throws Exception {
        boolean flag = false;
        Timeline timeline = new Timeline();
        timeline.client.setToken(token);
        try {
            timeline.UpdateStatus(content);
            flag = true;
        }
        catch (WeiboException e) {
            flag = false;
            System.out.println(e.getErrorCode());
        }
        return flag;
    }

    public static void sent(WeiboAccount weiboAccount, String content) throws Exception {
        AccessToken at = WeiboClient.getToken(weiboAccount.getUsername(), weiboAccount.getPassword());
        String accessToken = at.getAccessToken();
        System.out.println(accessToken);
        WeiboClient.sinaSendWeibo(accessToken, content);
    }
}

