/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.weibo;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.java.sezpoz.Index;
import net.java.sezpoz.IndexItem;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.jenkinsci.plugins.weibo.WeiboAccount;
import org.jenkinsci.plugins.weibo.client.WeiboClient;
import org.jenkinsci.plugins.weibo.token.WeiboToken;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeiboNotifier
extends Notifier {
    public static final String DEFAULT_CONTENT_KEY = "${DEFAULT_CONTENT}";
    public static final String DEFAULT_CONTENT_VALUE = "${BUILD_STATUS}  ${JOB_NAME} #${BUILD_NUMBER}  ${JOB_URL}";
    private final boolean disable;
    private final String weiboAccountId;
    private final String publishContent;

    @DataBoundConstructor
    public WeiboNotifier(boolean disable, String weiboAccountId, String publishContent) {
        this.disable = disable;
        this.weiboAccountId = weiboAccountId;
        this.publishContent = publishContent;
        System.out.println("save:");
        System.out.println(disable);
        System.out.println(weiboAccountId);
        System.out.println(publishContent);
    }

    public String getPublishContent() {
        return this.publishContent;
    }

    public String getWeiboAccountId() {
        return this.weiboAccountId;
    }

    public boolean isDisable() {
        return this.disable;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        if (!this.disable) {
            logger.println("[Weibo Plugin]================[start]=================");
            try {
                DescriptorImpl descriptor = this.getDescriptor();
                WeiboAccount weiboAccount = descriptor.getWeiboAccount(this.weiboAccountId);
                logger.println("[Weibo Plugin][Expand content]Before Expand: " + this.publishContent);
                String publishContentAfterInitialExpand = this.publishContent;
                if (this.publishContent.contains(DEFAULT_CONTENT_KEY)) {
                    publishContentAfterInitialExpand = this.publishContent.replace(DEFAULT_CONTENT_KEY, DEFAULT_CONTENT_VALUE);
                }
                String expandAll = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)publishContentAfterInitialExpand, (boolean)false, WeiboNotifier.getPrivateMacros());
                logger.println("[Weibo Plugin][Expand content]After Expand: " + expandAll);
                logger.println("[Weibo Plugin][Publish Content][begin]use:" + weiboAccount);
                WeiboClient.sent(weiboAccount, expandAll);
                logger.println("[Weibo Plugin][Publish Content][end]");
                logger.println("[Weibo Plugin]================[end][success]=================");
            }
            catch (Exception e) {
                logger.println("[Weibo Plugin]" + e.getMessage());
                logger.println("[Weibo Plugin]" + Arrays.toString(e.getStackTrace()));
                logger.println("[Weibo Plugin]================[end][failure]=================");
            }
        } else {
            logger.println("[Weibo Plugin]================[skiped]=================");
        }
        return true;
    }

    private static List<TokenMacro> getPrivateMacros() {
        ArrayList<TokenMacro> macros = new ArrayList<TokenMacro>();
        ClassLoader cl = Jenkins.getInstance().pluginManager.uberClassLoader;
        for (IndexItem item : Index.load(WeiboToken.class, TokenMacro.class, (ClassLoader)cl)) {
            try {
                macros.add((TokenMacro)item.instance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return macros;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private final CopyOnWriteList<WeiboAccount> weiboAccounts = new CopyOnWriteList();

        public DescriptorImpl() {
            super(WeiboNotifier.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public WeiboAccount[] getWeiboAccounts() {
            return (WeiboAccount[])this.weiboAccounts.toArray((Object[])new WeiboAccount[this.weiboAccounts.size()]);
        }

        public WeiboAccount getWeiboAccount(String weiboAccountId) {
            for (WeiboAccount weiboAccount : this.weiboAccounts) {
                if (!weiboAccount.getId().equalsIgnoreCase(weiboAccountId)) continue;
                return weiboAccount;
            }
            throw new RuntimeException("no such key: " + weiboAccountId);
        }

        public String getDisplayName() {
            return "Weibo Notification";
        }

        public FormValidation doIdCheck(@QueryParameter String id) throws IOException, ServletException {
            FormValidation basicVerify = this.returnVerify(id, "id");
            if (basicVerify.kind.equals((Object)FormValidation.ok().kind)) {
                int total = 0;
                for (WeiboAccount weiboAccount : this.weiboAccounts) {
                    if (!weiboAccount.getId().equalsIgnoreCase(id.trim())) continue;
                    ++total;
                }
                if (total > 1) {
                    return FormValidation.error((String)("duplicated id: " + id));
                }
                return FormValidation.ok();
            }
            return basicVerify;
        }

        public FormValidation doPasswordCheck(@QueryParameter String password) throws IOException, ServletException {
            return this.returnVerify(password, "password");
        }

        public FormValidation doUsernameCheck(@QueryParameter String username) throws IOException, ServletException {
            return this.returnVerify(username, "username");
        }

        private FormValidation returnVerify(String value, String message) {
            if (value == null || value.length() == 0) {
                return FormValidation.error((String)("please input " + message));
            }
            return FormValidation.ok();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.weiboAccounts.replaceBy((Collection)req.bindParametersToList(WeiboAccount.class, "weibo.account."));
            for (WeiboAccount weiboAccount : this.weiboAccounts) {
                System.out.println(weiboAccount);
            }
            this.save();
            return true;
        }
    }
}

