/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.websphere_deployer;

import com.ibm.icu.text.SimpleDateFormat;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.websphere.services.deployment.Artifact;
import org.jenkinsci.plugins.websphere.services.deployment.DeploymentServiceException;
import org.jenkinsci.plugins.websphere.services.deployment.Server;
import org.jenkinsci.plugins.websphere.services.deployment.WebSphereDeploymentService;
import org.jenkinsci.plugins.websphere_deployer.WebSphereSecurity;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class WebSphereDeployerPlugin
extends Notifier {
    private static final String OPERATION_REINSTALL = "1";
    private final String ipAddress;
    private final String connectorType;
    private final String port;
    private final String artifacts;
    private final String earLevel;
    private final String deploymentTimeout;
    private final String classLoaderOrder;
    private final String classLoaderPolicy;
    private final String operations;
    private final String context;
    private final String installPath;
    private final String targets;
    private final String applicationName;
    private final String virtualHost;
    private final String sharedLibName;
    private final String edition;
    private final boolean fullSynchronization;
    private final boolean precompile;
    private final boolean reloading;
    private final boolean jspReloading;
    private final boolean verbose;
    private final boolean distribute;
    private final boolean rollback;
    private final boolean unstableDeploy;
    private final WebSphereSecurity security;

    @DataBoundConstructor
    public WebSphereDeployerPlugin(String ipAddress, String connectorType, String port, String installPath, WebSphereSecurity security, String artifacts, String earLevel, String deploymentTimeout, String operations, String context, String targets, String applicationName, String virtualHost, String sharedLibName, String edition, boolean fullSynchronization, boolean precompile, boolean reloading, boolean jspReloading, boolean verbose, boolean distribute, boolean rollback, boolean unstableDeploy, String classLoaderPolicy, String classLoaderOrder) {
        this.context = context;
        this.targets = targets;
        this.installPath = installPath;
        this.ipAddress = ipAddress;
        this.connectorType = connectorType;
        this.artifacts = artifacts;
        this.port = port;
        this.operations = operations;
        this.earLevel = earLevel;
        this.deploymentTimeout = deploymentTimeout;
        this.edition = edition;
        this.fullSynchronization = fullSynchronization;
        this.precompile = precompile;
        this.reloading = reloading;
        this.jspReloading = jspReloading;
        this.verbose = verbose;
        this.distribute = distribute;
        this.rollback = rollback;
        this.unstableDeploy = unstableDeploy;
        this.security = security;
        this.classLoaderPolicy = classLoaderPolicy;
        this.classLoaderOrder = classLoaderOrder;
        this.applicationName = applicationName;
        this.virtualHost = virtualHost;
        this.sharedLibName = sharedLibName;
    }

    public String getEdition() {
        return this.edition;
    }

    public String getClassLoaderOrder() {
        return this.classLoaderOrder;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getClassLoaderPolicy() {
        return this.classLoaderPolicy;
    }

    public String getTargets() {
        return this.targets;
    }

    public String getEarLevel() {
        return this.earLevel;
    }

    public WebSphereSecurity getSecurity() {
        return this.security;
    }

    public boolean isDistribute() {
        return this.distribute;
    }

    public boolean isFullSynchronization() {
        return this.fullSynchronization;
    }

    public boolean isPrecompile() {
        return this.precompile;
    }

    public boolean isReloading() {
        return this.reloading;
    }

    public boolean isJspReloading() {
        return this.jspReloading;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isRollback() {
        return this.rollback;
    }

    public boolean isUnstableDeploy() {
        return this.unstableDeploy;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getContext() {
        return this.context;
    }

    public String getInstallPath() {
        return this.installPath;
    }

    public String getConnectorType() {
        return this.connectorType;
    }

    public String getPort() {
        return this.port;
    }

    public String getArtifacts() {
        return this.artifacts;
    }

    public String getOperations() {
        return this.operations;
    }

    public String getDeploymentTimeout() {
        return this.deploymentTimeout;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public String getSharedLibName() {
        return this.sharedLibName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        if (build == null) {
            throw new IllegalStateException("Build cannot be null");
        }
        Result buildResult = build.getResult();
        if (buildResult == null) {
            throw new IllegalStateException("Build result cannot be null");
        }
        if (this.shouldDeploy(buildResult)) {
            WebSphereDeploymentService service = new WebSphereDeploymentService();
            Artifact artifact = null;
            try {
                EnvVars env = build.getEnvironment((TaskListener)listener);
                this.preInitializeService(listener, service, env);
                service.connect();
                for (FilePath path : this.gatherArtifactPaths(build, listener)) {
                    artifact = this.createArtifact(path, listener, service);
                    this.log(listener, "Artifact is being deployed to virtual host: " + artifact.getVirtualHost());
                    this.stopArtifact(artifact, listener, service);
                    if (this.getOperations().equals(OPERATION_REINSTALL)) {
                        this.uninstallArtifact(artifact, listener, service);
                        this.deployArtifact(artifact, listener, service);
                    } else if (!service.isArtifactInstalled(artifact)) {
                        this.deployArtifact(artifact, listener, service);
                    } else {
                        this.updateArtifact(artifact, listener, service);
                    }
                    if (this.isFullSynchronization()) {
                        service.fullyResynchronizeNodes();
                    }
                    this.startArtifact(artifact, listener, service);
                    if (!this.rollback) continue;
                    this.saveArtifactToRollbackRepository(build, listener, artifact);
                }
            }
            catch (Exception e) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream p = null;
                try {
                    p = new PrintStream((OutputStream)out, true, "UTF-8");
                }
                catch (UnsupportedEncodingException e2) {
                    e2.printStackTrace();
                }
                e.printStackTrace(p);
                if (this.verbose) {
                    try {
                        this.logVerbose(listener, "Error deploying to IBM WebSphere Application Server: " + new String(out.toByteArray(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    this.log(listener, "Error deploying to IBM WebSphere Application Server: " + e.getMessage());
                }
                this.rollbackArtifact(service, build, listener, artifact);
                build.setResult(Result.FAILURE);
            }
            finally {
                service.disconnect();
            }
        } else {
            listener.getLogger().println("Unable to deploy to IBM WebSphere Application Server, Build Result = " + buildResult);
        }
        return true;
    }

    private boolean shouldDeploy(Result result) {
        if (result.equals(Result.SUCCESS)) {
            return true;
        }
        return this.unstableDeploy && result.equals(Result.UNSTABLE);
    }

    private void log(BuildListener listener, String data) {
        listener.getLogger().println(data);
    }

    private void logVerbose(BuildListener listener, String data) {
        if (this.verbose) {
            this.log(listener, data);
        }
    }

    private void rollbackArtifact(WebSphereDeploymentService service, AbstractBuild build, BuildListener listener, Artifact artifact) {
        if (build == null) {
            this.log(listener, "Cannot rollback to previous verions: build is null");
        }
        if (artifact == null) {
            this.log(listener, "Cannot rollback to previous version: artifact is null");
            return;
        }
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            this.log(listener, "Cannot rollback to previous version: workspace is null");
            return;
        }
        String remote = workspace.getRemote();
        if (remote == null) {
            this.log(listener, "Cannot rollback to previous version: remote path is null");
            return;
        }
        this.log(listener, "Performing rollback of '" + artifact.getAppName() + "'");
        File installablePath = new File(remote + File.separator + "Rollbacks" + File.separator + artifact.getAppName() + "." + artifact.getTypeName());
        if (installablePath.exists()) {
            artifact.setSourcePath(installablePath);
            try {
                this.updateArtifact(artifact, listener, service);
                this.startArtifact(artifact, listener, service);
                this.log(listener, "Rollback of '" + artifact.getAppName() + "' was successful");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log(listener, "Error while trying to rollback to previous version: " + e.getMessage());
            }
        } else {
            this.log(listener, "WARNING: Artifact doesn't exist rollback repository");
        }
    }

    private void saveArtifactToRollbackRepository(AbstractBuild build, BuildListener listener, Artifact artifact) {
        listener.getLogger().println("Performing save operations on '" + artifact.getAppName() + "' for future rollbacks");
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            this.log(listener, "Failed to save rollback to repository: Build workspace is null");
            throw new IllegalStateException("Failed to save rollback to repository: Build workspace is null");
        }
        String remote = workspace.getRemote();
        if (remote == null) {
            this.log(listener, "Failed to save rollback to repository: Build workspace remote path is null");
            throw new IllegalStateException("Failed to save rollback to repository: Build workspace remote path is null");
        }
        File rollbackDir = new File(remote + File.separator + "Rollbacks");
        this.createIfNotExists(listener, rollbackDir);
        this.logVerbose(listener, "Rollback Path: " + rollbackDir.getAbsolutePath());
        File destination = new File(rollbackDir, artifact.getAppName() + "." + artifact.getTypeName());
        if (destination.exists()) {
            this.log(listener, "Deleting old rollback version...");
            if (!destination.delete()) {
                this.log(listener, "Failed to delete old rollback version, permissions?: " + destination.getAbsolutePath());
                return;
            }
        }
        this.log(listener, "Saving new rollback version...");
        if (!artifact.getSourcePath().renameTo(destination)) {
            this.logVerbose(listener, "Failed to save '" + artifact.getAppName() + "' to rollback repository");
        } else {
            this.log(listener, "Saved '" + artifact.getAppName() + "' to rollback repository");
        }
    }

    private void createIfNotExists(BuildListener listener, File directory) {
        if (directory.exists() || directory.mkdir()) {
            return;
        }
        throw new DeploymentServiceException("Failed to create directory, is write access allowed?: " + directory.getAbsolutePath());
    }

    private void deployArtifact(Artifact artifact, BuildListener listener, WebSphereDeploymentService service) throws Exception {
        listener.getLogger().println("Deploying '" + artifact.getAppName() + "' to IBM WebSphere Application Server");
        service.installArtifact(artifact);
    }

    private void uninstallArtifact(Artifact artifact, BuildListener listener, WebSphereDeploymentService service) throws Exception {
        if (service.isArtifactInstalled(artifact)) {
            listener.getLogger().println("Uninstalling Old Application '" + artifact.getAppName() + "'...");
            service.uninstallArtifact(artifact);
        }
    }

    private void startArtifact(Artifact artifact, BuildListener listener, WebSphereDeploymentService service) throws Exception {
        if (StringUtils.trimToNull((String)artifact.getEdition()) != null) {
            listener.getLogger().println(artifact.getAppName() + " will not be started automatically because 'Edition' management was used in the jenkins configuration");
            return;
        }
        listener.getLogger().println("Starting Application '" + artifact.getAppName() + "'...");
        try {
            service.startArtifact(artifact, Integer.parseInt(this.getDeploymentTimeout()));
        }
        catch (NumberFormatException e) {
            service.startArtifact(artifact);
        }
    }

    private void stopArtifact(Artifact artifact, BuildListener listener, WebSphereDeploymentService service) throws Exception {
        if (service.isArtifactInstalled(artifact)) {
            listener.getLogger().println("Stopping Existing Application '" + artifact.getAppName() + "'...");
            service.stopArtifact(artifact);
        }
    }

    private void updateArtifact(Artifact artifact, BuildListener listener, WebSphereDeploymentService service) throws Exception {
        if (service.isArtifactInstalled(artifact)) {
            listener.getLogger().println("Updating '" + artifact.getAppName() + "' on IBM WebSphere Application Server");
            service.updateArtifact(artifact);
        }
    }

    private Artifact createArtifact(FilePath path, BuildListener listener, WebSphereDeploymentService service) {
        Artifact artifact = new Artifact();
        if (path.getRemote().endsWith(".ear")) {
            artifact.setType(1);
        } else if (path.getRemote().endsWith(".war")) {
            artifact.setType(2);
        }
        if (StringUtils.trimToNull((String)this.context) != null) {
            artifact.setContext(this.context);
        }
        if (StringUtils.trimToNull((String)this.virtualHost) == null) {
            artifact.setVirtualHost("default_host");
        } else {
            artifact.setVirtualHost(this.virtualHost);
        }
        artifact.setClassLoaderOrder(this.classLoaderOrder);
        artifact.setClassLoaderPolicy(this.classLoaderPolicy);
        artifact.setTargets(this.targets);
        artifact.setInstallPath(this.installPath);
        artifact.setJspReloading(this.reloading);
        artifact.setDistribute(this.distribute);
        if (StringUtils.trimToNull((String)this.edition) != null) {
            artifact.setEdition(this.edition);
        }
        artifact.setPrecompile(this.isPrecompile());
        artifact.setSourcePath(new File(path.getRemote()));
        if (StringUtils.trimToNull((String)this.applicationName) != null) {
            artifact.setAppName(this.applicationName);
        } else {
            artifact.setAppName(this.getAppName(artifact, service));
        }
        if (artifact.getType() == 2) {
            this.generateEAR(artifact, listener, service);
        }
        return artifact;
    }

    private FilePath[] gatherArtifactPaths(AbstractBuild build, BuildListener listener) throws Exception {
        if (build == null) {
            this.log(listener, "Cannot gather artifact paths: Build is null");
            throw new IllegalStateException("Cannot gather artifact paths: Build is null");
        }
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            this.log(listener, "Cannot gather artifact paths: Build workspace is null");
            throw new IllegalStateException("Cannot gather artifact paths: Build workspace is null");
        }
        FilePath workspaceParent = workspace.getParent();
        if (workspaceParent == null) {
            this.log(listener, "Cannot gather artifact paths: Build workspace's parent folder is null");
            throw new IllegalStateException("Cannot gather artifact paths: Build workspace's parent folder is null");
        }
        String artifacts = this.getArtifacts();
        if (artifacts == null) {
            this.log(listener, "Cannot gather artifact paths: Artifacts are null");
            throw new IllegalStateException("Cannot gather artifact paths: Artifacts are null");
        }
        FilePath[] paths = workspaceParent.list(artifacts);
        if (paths.length == 0) {
            listener.getLogger().println("No deployable artifacts found in path: " + workspaceParent + File.separator + artifacts);
            throw new Exception("No deployable artifacts found!");
        }
        listener.getLogger().println("The following artifacts will be deployed in this order...");
        listener.getLogger().println("-------------------------------------------");
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss");
        for (FilePath path : paths) {
            listener.getLogger().println(path.getRemote() + " Last modified on " + sdf.format((Object)path.lastModified()));
        }
        listener.getLogger().println("-------------------------------------------");
        return paths;
    }

    private void preInitializeService(BuildListener listener, WebSphereDeploymentService service, EnvVars env) throws Exception {
        listener.getLogger().println("Connecting to IBM WebSphere Application Server...");
        service.setVerbose(this.isVerbose());
        service.setBuildListener(listener);
        service.setConnectorType(this.getConnectorType());
        service.setHost(env.expand(this.getIpAddress()));
        service.setPort(env.expand(this.getPort()));
        if (this.security != null) {
            service.setUsername(env.expand(this.security.getUsername()));
            service.setPassword(env.expand(this.security.getPassword()));
            service.setKeyStoreLocation(new File(env.expand(this.security.getClientKeyFile())));
            service.setKeyStorePassword(env.expand(this.security.getClientKeyPassword()));
            service.setTrustStoreLocation(new File(env.expand(this.security.getClientTrustFile())));
            service.setTrustStorePassword(env.expand(this.security.getClientTrustPassword()));
            service.setTrustAll(this.security.isTrustAll());
        }
    }

    private String getAppName(Artifact artifact, WebSphereDeploymentService service) {
        if (artifact.getType() == 1) {
            return service.getAppName(artifact.getSourcePath().getAbsolutePath());
        }
        String filename = artifact.getSourcePath().getName();
        return filename.substring(0, filename.lastIndexOf("."));
    }

    private void generateEAR(Artifact artifact, BuildListener listener, WebSphereDeploymentService service) {
        listener.getLogger().println("Generating EAR For Artifact: " + artifact.getAppName());
        File modified = new File(artifact.getSourcePath().getParent(), artifact.getAppName() + ".ear");
        service.generateEAR(artifact, modified, this.getEarLevel());
        artifact.setSourcePath(modified);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String adminClientPath;
        private String orbClientPath;

        public DescriptorImpl() {
            this.load();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FormValidation doLoadTargets(@QueryParameter(value="ipAddress") String ipAddress, @QueryParameter(value="connectorType") String connectorType, @QueryParameter(value="port") String port, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="trustAll") String trustAll) throws IOException, ServletException {
            WebSphereDeploymentService service = new WebSphereDeploymentService();
            try {
                FormValidation i$;
                if (!service.isAvailable()) {
                    String destination = "<Jenkins_Root>" + File.separator + "plugins" + File.separator + "websphere-deployer" + File.separator + "WEB-INF" + File.separator + "lib" + File.separator;
                    FormValidation formValidation = FormValidation.warning((String)("Cannot find the required IBM WebSphere Application Server jar files in '" + destination + "'. Please copy them from IBM WebSphere Application Server (see plugin documentation)"));
                    return formValidation;
                }
                service.setConnectorType(connectorType);
                service.setHost(ipAddress);
                service.setUsername(username);
                service.setPassword(password);
                service.setPort(port);
                service.setTrustAll(Boolean.valueOf(trustAll));
                service.connect();
                List<Server> servers = service.listServers();
                StringBuffer buffer = new StringBuffer();
                buffer.append("\r\n\r\n");
                for (Server server : servers) {
                    if (buffer.length() > 0) {
                        buffer.append("\r\n");
                    }
                    buffer.append(server.getTarget());
                }
                if (buffer.toString().trim().equals("")) {
                    i$ = FormValidation.warning((String)"No server targets are configured in WebSphere");
                    return i$;
                }
                i$ = FormValidation.ok((String)buffer.toString());
                return i$;
            }
            catch (Exception e) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream p = new PrintStream((OutputStream)out, true, "UTF-8");
                e.printStackTrace(p);
                FormValidation formValidation = FormValidation.error((String)("Failed to list targets =>" + new String(out.toByteArray(), "UTF-8")));
                return formValidation;
            }
            finally {
                service.disconnect();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FormValidation doTestConnection(@QueryParameter(value="ipAddress") String ipAddress, @QueryParameter(value="connectorType") String connectorType, @QueryParameter(value="port") String port, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="trustAll") String trustAll) throws IOException, ServletException {
            WebSphereDeploymentService service = new WebSphereDeploymentService();
            try {
                if (!service.isAvailable()) {
                    String destination = "<Jenkins_Root>" + File.separator + "plugins" + File.separator + "websphere-deployer" + File.separator + "WEB-INF" + File.separator + "lib" + File.separator;
                    FormValidation formValidation = FormValidation.warning((String)("Cannot find the required IBM WebSphere Application Server jar files in '" + destination + "'. Please copy them from IBM WebSphere Application Server (see plugin documentation)"));
                    return formValidation;
                }
                service.setConnectorType(connectorType);
                service.setHost(ipAddress);
                service.setUsername(username);
                service.setPassword(password);
                service.setPort(port);
                service.setTrustAll(Boolean.valueOf(trustAll));
                service.connect();
                FormValidation destination = FormValidation.ok((String)"Connection Successful!");
                return destination;
            }
            catch (Exception e) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream p = new PrintStream((OutputStream)out, true, "UTF-8");
                e.printStackTrace(p);
                FormValidation formValidation = FormValidation.error((String)("Connection failed from Jenkins to https://" + ipAddress + ":" + port + " => " + new String(out.toByteArray(), "UTF-8")));
                return formValidation;
            }
            finally {
                service.disconnect();
            }
        }

        public FormValidation doCheckPort(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Select a port");
            }
            if (value.length() > 5) {
                return FormValidation.warning((String)"Cannot be greater than 65535");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckApplicationName(@QueryParameter String value) throws IOException, ServletException {
            if (StringUtils.trimToNull((String)value) == null) {
                return FormValidation.warning((String)"This setting is required for rollback support");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAdminClientPath(@QueryParameter String value) throws IOException, ServletException {
            if (!new File(value).exists()) {
                return FormValidation.error((String)("Path '" + value + "' is not found"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOrbClientPath(@QueryParameter String value) throws IOException, ServletException {
            if (!new File(value).exists()) {
                return FormValidation.error((String)("Path '" + value + "' is not found"));
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Deploy To IBM WebSphere Application Server";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.adminClientPath = formData.getString("adminClientPath");
            this.orbClientPath = formData.getString("orbClientPath");
            this.save();
            return super.configure(req, formData);
        }

        public String getAdminClientPath() {
            return this.adminClientPath;
        }

        public String getOrbClientPath() {
            return this.orbClientPath;
        }
    }
}

