/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.websphere.services.deployment;

import com.ibm.websphere.application.ApplicationMBean;
import com.ibm.websphere.filetransfer.FileTransferMBean;
import java.io.IOException;
import java.util.HashMap;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jenkinsci.plugins.websphere.services.deployment.AbstractDeploymentService;
import org.jenkinsci.plugins.websphere.services.deployment.Artifact;
import org.jenkinsci.plugins.websphere.services.deployment.DeploymentServiceException;

public class LibertyDeploymentService
extends AbstractDeploymentService {
    private JMXConnector connector;
    private MBeanServerConnection client;

    @Override
    public void installArtifact(Artifact artifact) {
        try {
            ObjectName fileTransferServiceMBean = new ObjectName("WebSphere:feature=restConnector,type=FileTransfer,name=FileTransfer");
            if (!this.client.isRegistered(fileTransferServiceMBean)) {
                throw new Exception("FileTransfer MBean not registered on WebSphere Liberty Profile");
            }
            FileTransferMBean bean = JMX.newMBeanProxy(this.client, fileTransferServiceMBean, FileTransferMBean.class);
            bean.uploadFile(artifact.getSourcePath().getAbsolutePath(), "${server.output.dir}/dropins/" + artifact.getSourcePath().getName(), false);
        }
        catch (Exception e) {
            throw new DeploymentServiceException("Failed to install artifact: " + e.getMessage());
        }
    }

    @Override
    public void uninstallArtifact(Artifact artifact) {
        try {
            ObjectName fileTransferServiceMBean = new ObjectName("WebSphere:feature=restConnector,type=FileTransfer,name=FileTransfer");
            if (!this.client.isRegistered(fileTransferServiceMBean)) {
                throw new Exception("FileTransfer MBean not registered on WebSphere Liberty Profile");
            }
            FileTransferMBean bean = JMX.newMBeanProxy(this.client, fileTransferServiceMBean, FileTransferMBean.class);
            bean.deleteFile("${server.output.dir}/dropins/" + artifact.getAppName());
        }
        catch (Exception e) {
            throw new DeploymentServiceException("Failed to uninstall artifact: " + e.getMessage());
        }
    }

    @Override
    public void startArtifact(Artifact artifact) {
        try {
            ObjectName applicationMBean = new ObjectName("WebSphere:service=com.ibm.websphere.application.ApplicationMBean,name=" + artifact.getAppName());
            if (!this.client.isRegistered(applicationMBean)) {
                throw new Exception("Application '" + artifact.getAppName() + "' is not installed");
            }
            ApplicationMBean bean = JMX.newMBeanProxy(this.client, applicationMBean, ApplicationMBean.class);
            bean.start();
        }
        catch (Exception e) {
            throw new DeploymentServiceException("Failed to start artifact: " + e.getMessage());
        }
    }

    @Override
    public void stopArtifact(Artifact artifact) {
        try {
            ObjectName applicationMBean = new ObjectName("WebSphere:service=com.ibm.websphere.application.ApplicationMBean,name=" + artifact.getAppName());
            if (!this.client.isRegistered(applicationMBean)) {
                throw new Exception("Application '" + artifact.getAppName() + "' is not installed");
            }
            ApplicationMBean bean = JMX.newMBeanProxy(this.client, applicationMBean, ApplicationMBean.class);
            bean.stop();
        }
        catch (Exception e) {
            throw new DeploymentServiceException("Failed to stop artifact: " + e.getMessage());
        }
    }

    @Override
    public boolean isArtifactInstalled(Artifact artifact) {
        try {
            ObjectName applicationMBean = new ObjectName("WebSphere:service=com.ibm.websphere.application.ApplicationMBean,name=" + artifact.getAppName());
            return this.client.isRegistered(applicationMBean);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void connect() throws Exception {
        ClassLoader loader = this.getClass().getClassLoader();
        if (loader.toString().startsWith("AntClassLoader")) {
            Thread.currentThread().setContextClassLoader(loader);
        }
        System.setProperty("javax.net.ssl.trustStore", this.getTrustStoreLocation().getAbsolutePath());
        System.setProperty("javax.net.ssl.trustStorePassword", this.getTrustStorePassword());
        HashMap<String, Object> environment = new HashMap<String, Object>();
        environment.put("jmx.remote.protocol.provider.pkgs", "com.ibm.ws.jmx.connector.client");
        environment.put("com.ibm.ws.jmx.connector.client.disableURLHostnameVerification", true);
        environment.put("jmx.remote.credentials", new String[]{this.getUsername(), this.getPassword()});
        JMXServiceURL url = new JMXServiceURL("service:jmx:rest://" + this.getHost() + ":" + this.getPort() + "/IBMJMXConnectorREST");
        this.connector = JMXConnectorFactory.newJMXConnector(url, environment);
        this.connector.connect();
        this.client = this.connector.getMBeanServerConnection();
        if (this.client == null) {
            throw new Exception("Failed to connect to IBM WebSphere Liberty Profile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.connector = null;
            }
        }
    }

    @Override
    public boolean isAvailable() {
        try {
            Class.forName("com.ibm.ws.jmx.connector.client.rest.ClientProvider", false, this.getClass().getClassLoader());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isConnected() {
        return this.connector != null;
    }

    @Override
    public void updateArtifact(Artifact artifact) {
        throw new UnsupportedOperationException();
    }
}

