/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.websphere.services.deployment;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.application.AppNotification;
import hudson.model.BuildListener;
import java.util.Properties;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class DeploymentNotificationListener
implements NotificationListener {
    private static Logger log = Logger.getLogger(DeploymentNotificationListener.class.getName());
    private AdminClient adminClient;
    private NotificationFilterSupport filterSupport;
    private ObjectName objectName;
    private String eventTypeToCheck;
    private boolean successful = true;
    private String message = "";
    private Properties notificationProps = new Properties();
    private BuildListener listener;
    private boolean verbose;
    private boolean eventTriggered;

    public DeploymentNotificationListener(AdminClient adminClient, NotificationFilterSupport support, Object handBack, String eventTypeToCheck, BuildListener listener, boolean verbose) throws Exception {
        this.adminClient = adminClient;
        this.filterSupport = support;
        this.eventTypeToCheck = eventTypeToCheck;
        this.listener = listener;
        this.verbose = verbose;
        this.objectName = (ObjectName)adminClient.queryNames(new ObjectName("WebSphere:type=AppManagement,*"), null).iterator().next();
        adminClient.addNotificationListener(this.objectName, (NotificationListener)this, (NotificationFilter)this.filterSupport, handBack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object handback) {
        AppNotification appNotification = (AppNotification)notification.getUserData();
        if (this.verbose) {
            this.listener.getLogger().println(appNotification.taskName + "] " + appNotification.message + "[" + appNotification.taskStatus + "]");
        }
        this.message = this.message + "\n" + appNotification.message;
        if (appNotification.taskName.equals(this.eventTypeToCheck) && (appNotification.taskStatus.equals("Completed") || appNotification.taskStatus.equals("Failed"))) {
            try {
                this.adminClient.removeNotificationListener(this.objectName, (NotificationListener)this);
                if (appNotification.taskStatus.equals("Failed")) {
                    this.successful = false;
                } else {
                    this.notificationProps = appNotification.props;
                }
                DeploymentNotificationListener deploymentNotificationListener = this;
                synchronized (deploymentNotificationListener) {
                    this.eventTriggered = true;
                    this.notify();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean hasEventTriggered() {
        return this.eventTriggered;
    }

    public String getMessage() {
        return this.message;
    }

    public Properties getNotificationProps() {
        return this.notificationProps;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public AdminClient getAdminClient() {
        return this.adminClient;
    }

    public NotificationFilterSupport getFilterSupport() {
        return this.filterSupport;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }
}

