/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic.util;

import hudson.EnvVars;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParameterValueResolver {
    private static final Pattern ENV_VAR_PATTERN = Pattern.compile("\\$\\{?([\\S&&[^}]]*)\\}?");

    public static String resolveEnvVar(String label, EnvVars envars) {
        Matcher matcher = ENV_VAR_PATTERN.matcher(label);
        if (matcher.matches()) {
            String key = matcher.group(1);
            return envars.get(key, label);
        }
        return label;
    }

    public static String resolveEnvVars(String label, EnvVars envars) {
        Matcher m;
        if (label != null && (m = ENV_VAR_PATTERN.matcher(label)) != null) {
            while (m.find()) {
                label = label.replace(m.group(), ParameterValueResolver.resolveEnvVar(m.group(), envars));
            }
        }
        return label;
    }
}

