/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.deploy.weblogic.ArtifactSelector;
import org.jenkinsci.plugins.deploy.weblogic.util.VarUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeStyleJobArtifactSelectorImpl
implements ArtifactSelector {
    @Override
    public FilePath selectArtifactRecorded(AbstractBuild<?, ?> build, BuildListener listener, String filteredResource, String baseDirectory) throws IOException, InterruptedException {
        FilePath selectedArtifact = null;
        listener.getLogger().println("[WeblogicDeploymentPlugin] - Retrieving artifacts recorded [filtered resources on " + filteredResource + "]...");
        ArrayList<FilePath> artifactsRecorded = new ArrayList<FilePath>();
        Collection filesToCheck = CollectionUtils.EMPTY_COLLECTION;
        String baseDirName = "";
        if (StringUtils.isBlank((String)baseDirectory)) {
            FilePath workspace = build.getWorkspace();
            baseDirName = workspace.getName();
            filesToCheck = FileUtils.listFiles((File)new File(workspace.toURI()), null, (boolean)true);
        } else {
            EnvVars vars = VarUtils.getEnvVars(build, listener);
            String resolvedBaseDirectory = vars.expand(baseDirectory);
            File baseDir = new File(resolvedBaseDirectory);
            if (!(baseDir.exists() && baseDir.isDirectory() && baseDir.canRead())) {
                listener.getLogger().println("[WeblogicDeploymentPlugin] - the base directory specified [" + resolvedBaseDirectory + "] is invalid (doesn't exists or is not a directory or has insufficient privilege). Please check the job configuration");
                throw new RuntimeException("The base directory specified [" + resolvedBaseDirectory + "] is invalid (doesn't exists or is not a directory or has insufficient privilege)");
            }
            baseDirName = baseDir.getName();
            filesToCheck = FileUtils.listFiles((File)baseDir, null, (boolean)true);
        }
        listener.getLogger().println("[WeblogicDeploymentPlugin] - " + filesToCheck.size() + " files found under " + baseDirName);
        for (File file : filesToCheck) {
            if (!file.isDirectory() && Pattern.matches(filteredResource, file.getName())) {
                listener.getLogger().println("[WeblogicDeploymentPlugin] - the following resource recorded " + file.getAbsolutePath() + " is eligible.");
                artifactsRecorded.add(new FilePath(file));
                continue;
            }
            listener.getLogger().println("[WeblogicDeploymentPlugin] - the following resource ['" + file.getName() + "'] doesn't match " + filteredResource);
        }
        if (artifactsRecorded.size() < 1) {
            throw new RuntimeException("No artifact to deploy [" + filteredResource + "] found.");
        }
        if (artifactsRecorded.size() > 1) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - More than 1 artifact found : The first one " + artifactsRecorded.get(0) + " will be deployed!!!");
        }
        if ((selectedArtifact = (FilePath)artifactsRecorded.get(0)) == null) {
            throw new RuntimeException("No artifact to deploy found.");
        }
        return selectedArtifact;
    }

    @Override
    public String getName() {
        return "FreeStyleProject";
    }
}

