/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic.data;

import hudson.model.AbstractDescribableImpl;
import hudson.model.JDK;
import java.io.Serializable;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.deploy.weblogic.data.DeploymentTaskDescriptor;
import org.jenkinsci.plugins.deploy.weblogic.data.WebLogicStageMode;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentTask
extends AbstractDescribableImpl<DeploymentTask>
implements Serializable {
    private static final long serialVersionUID = 3924420945973321189L;
    private String id;
    private String weblogicEnvironmentTargetedName;
    private String deploymentName;
    private String deploymentTargets = "AdminServer";
    private boolean isLibrary;
    private String builtResourceRegexToDeploy;
    private String baseResourcesGeneratedDirectory;
    private String taskName;
    private JDK jdk;
    private WebLogicStageMode stageMode;
    private String commandLine;

    @DataBoundConstructor
    public DeploymentTask(String id, String taskName, String weblogicEnvironmentTargetedName, String deploymentName, String deploymentTargets, boolean isLibrary, String builtResourceRegexToDeploy, String baseResourcesGeneratedDirectory, String jdkName, String jdkHome, WebLogicStageMode stageMode, String commandLine) {
        this.id = id == null ? RandomStringUtils.randomAlphanumeric((int)10) : id;
        this.taskName = taskName;
        this.weblogicEnvironmentTargetedName = weblogicEnvironmentTargetedName;
        this.deploymentName = deploymentName;
        this.deploymentTargets = deploymentTargets;
        this.isLibrary = isLibrary;
        this.builtResourceRegexToDeploy = builtResourceRegexToDeploy;
        this.baseResourcesGeneratedDirectory = baseResourcesGeneratedDirectory;
        if (StringUtils.isNotBlank((String)jdkName)) {
            this.jdk = new JDK(jdkName, jdkHome);
        }
        this.stageMode = stageMode;
        this.commandLine = commandLine;
    }

    public DeploymentTaskDescriptor getDescriptor() {
        return (DeploymentTaskDescriptor)super.getDescriptor();
    }

    public String getWeblogicEnvironmentTargetedName() {
        return this.weblogicEnvironmentTargetedName;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public String getDeploymentTargets() {
        return this.deploymentTargets;
    }

    public boolean getIsLibrary() {
        return this.isLibrary;
    }

    public String getBuiltResourceRegexToDeploy() {
        return this.builtResourceRegexToDeploy;
    }

    public void setBuiltResourceRegexToDeploy(String builtResourceRegexToDeploy) {
        this.builtResourceRegexToDeploy = builtResourceRegexToDeploy;
    }

    public String getBaseResourcesGeneratedDirectory() {
        return this.baseResourcesGeneratedDirectory;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public JDK getJdk() {
        return this.jdk;
    }

    public WebLogicStageMode getStageMode() {
        return this.stageMode;
    }

    public String getCommandLine() {
        return this.commandLine;
    }
}

