/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic.deployer;

import hudson.model.Run;
import hudson.util.ArgumentListBuilder;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.deploy.weblogic.data.WebLogicStageMode;
import org.jenkinsci.plugins.deploy.weblogic.deployer.WebLogicCommand;
import org.jenkinsci.plugins.deploy.weblogic.deployer.WebLogicDeployerParameters;

public class WebLogicDeployer {
    public static final String[] getWebLogicCommandLine(WebLogicDeployerParameters parameter) {
        String targetedDeploymentName;
        ArgumentListBuilder args = new ArgumentListBuilder();
        if (parameter.getUsedJdk() == null) {
            parameter.getListener().error("[WeblogicDeploymentPlugin] - No JDK selected to deploy artifact.");
            throw new Run.RunnerAbortedException();
        }
        args.add(parameter.getUsedJdk().getBinDir().getAbsolutePath().concat("/java"));
        if (StringUtils.isNotBlank((String)parameter.getJavaOpts())) {
            String[] javaOptions = StringUtils.split((String)parameter.getJavaOpts(), (char)' ');
            args.add(javaOptions);
        }
        args.add("-cp");
        if (StringUtils.isBlank((String)parameter.getClasspath())) {
            parameter.getListener().error("[WeblogicDeploymentPlugin] - Classpath is not set. Please configure correctly the plugin.");
            throw new Run.RunnerAbortedException();
        }
        String remotingJar = parameter.getClasspath();
        args.add(remotingJar);
        args.add("weblogic.Deployer");
        args.add("-debug");
        if (!WebLogicCommand.UNDEPLOY.equals((Object)parameter.getCommand()) && !parameter.isLibrary()) {
            if (!WebLogicStageMode.bydefault.equals((Object)parameter.getStageMode())) {
                args.add("-" + parameter.getStageMode().name());
            } else {
                args.add("-stage");
            }
        }
        args.add("-remote");
        args.add("-verbose");
        if (!WebLogicCommand.UNDEPLOY.equals((Object)parameter.getCommand()) && !parameter.isLibrary()) {
            args.add("-upload");
        }
        if (parameter.isSilentMode()) {
            args.add("-noexit");
        }
        args.add("-name");
        String string = targetedDeploymentName = StringUtils.isNotBlank((String)parameter.getDeploymentName()) ? parameter.getDeploymentName() : parameter.getArtifactName();
        if (StringUtils.isBlank((String)targetedDeploymentName)) {
            // empty if block
        }
        args.add(targetedDeploymentName);
        if (StringUtils.isNotBlank((String)parameter.getSource())) {
            args.add("-source");
            args.add(parameter.getSource());
        }
        args.add("-targets");
        args.add(parameter.getDeploymentTargets());
        args.add("-adminurl");
        args.add("t3://" + parameter.getEnvironment().getHost() + ":" + parameter.getEnvironment().getPort());
        args.add("-user");
        args.add(parameter.getEnvironment().getLogin());
        args.add("-password");
        args.add(parameter.getEnvironment().getPassword());
        args.add("-" + parameter.getCommand().getValue());
        if (parameter.isLibrary()) {
            args.add("-library");
        }
        return args.toCommandArray();
    }
}

